
<?php

date_default_timezone_set("asia/tehran");

// require 
require_once  'class/Base.php';
require_once  'config.php';
require_once  'jdf.php';

$update = json_decode(file_get_contents('php://input'));

// Verify Telegram Updates
if (isset($update)) {
    $telegram_ip_ranges = [['lower' => '149.154.160.0', 'upper' => '149.154.175.255'], ['lower' => '91.108.4.0', 'upper' => '91.108.7.255'],];
    $ip_dec = (float) sprintf("%u", ip2long($_SERVER['REMOTE_ADDR']));
    $ok = false;
    foreach ($telegram_ip_ranges as $telegram_ip_range) if (!$ok) {
        $lower_dec = (float) sprintf("%u", ip2long($telegram_ip_range['lower']));
        $upper_dec = (float) sprintf("%u", ip2long($telegram_ip_range['upper']));
        if ($ip_dec >= $lower_dec and $ip_dec <= $upper_dec) $ok = true;
    }
    if (!$ok) die();
}
//===================== VARIABLES =====================\\
$MahdyarEn = new Base($token);
@$updateType = $MahdyarEn->getUpdateType();

@$date2 = tr_num(jdate('Y/m/d'));
$timeU = time();
@$from_id = $MahdyarEn->UserID();
@$chat_id = $MahdyarEn->ChatID();
@$message_id = $MahdyarEn->MessageID();
@$photo = $MahdyarEn->photo();
@$firstname = $MahdyarEn->FirstName();
@$channelTitle = $MahdyarEn->Title();
@$channelType = $MahdyarEn->Type();
@$voice_id = $MahdyarEn->voiceid();
@$file_id = $MahdyarEn->documentid();
@$caption = $MahdyarEn->Caption();
@$audio_id = $MahdyarEn->audioid();
@$sticker_id = $MahdyarEn->stickerid();
@$video_id = $MahdyarEn->videoid();
@$photo_id = $MahdyarEn->photoid();
@$gif_id  =  $MahdyarEn->gifid();
@$contact = $MahdyarEn->phone();
@$contactnum = $MahdyarEn->phonenu();
@$contactho = $MahdyarEn->phoneho();
@$data = $MahdyarEn->Callback_Data();
@$callback_id = $MahdyarEn->Callback_Data_Id();
@$getchat = $MahdyarEn->getChat(['chat_id' => $chat_id])['result'];
@$text = $MahdyarEn->protect($db, $MahdyarEn->Text());


// database Variable
@$user = $db->query("SELECT * FROM user WHERE id = '$from_id'")->fetch_assoc();
@$step = $user['step'];
@$lang = $user['lang'] ? $user['lang'] : 'fa';

if ($lang == "fa") {
    @$time = tr_num(jdate('H:i', strtotime("-1 hours")));
    @$date = jdate('l j F Y');
} else {
    @$time = date('H:i');
    @$date = date('y/m/d');
}

@$ban = $user['ban'];
@$dayStart = jdate("Y/m/d", $user['signin']);
@$stock = $user['stock'];
@$phone = $user['phone'];
@$phone = ($phone != null) ? __('verify') : __('unverify');
@$verify_stats = ($user['verify'] != null) ? __('verify') : __('unverify');
@$botStatus = $db->query("SELECT * FROM settings WHERE `type` = 'bot'")->fetch_assoc();
@$usdt_price = $db->query("SELECT * FROM settings WHERE `type_id` = 'usd_irr'")->fetch_assoc()['columnTwo'];
@$ton_price = $db->query("SELECT * FROM settings WHERE `type_id` = 'ton_price_usd'")->fetch_assoc()['columnTwo'];
@$profit_margin = $db->query("SELECT * FROM settings WHERE `type` = 'profit_margin'")->fetch_assoc()['type_id'];

@$prem3 = 11.99 * $usdt_price * (1 + $profit_margin);
@$prem6 = 15.99 * $usdt_price * (1 + $profit_margin);
@$prem12 = 28.99 * $usdt_price * (1 + $profit_margin);
@$star = 0.015 * $usdt_price * (1 + $profit_margin);
@$starsPrice = 0.015 * $usdt_price * (1 + $profit_margin);
@$tonPrice = $ton_price * $usdt_price * (1 + $profit_margin);

@$invite = $db->query("SELECT * FROM settings WHERE `type_id` = 'invite'")->fetch_assoc()['columnTwo'];
@$collection = $db->query("SELECT * FROM settings WHERE `type` = 'collection'")->fetch_assoc()['type_id'];
$gifts_list = json_decode(file_get_contents('gift_bot/gifts.json'), true);

//===================== KEYBOARDS =====================\\
if ((in_array($from_id, getAdmins()))) {
    if ($collection == "on") {

        $home = json_encode(['inline_keyboard' => [
            [['text' => __('home_products'), 'callback_data' => 'shopmenu']],
            [['text' => __('home_increase_stock'), 'callback_data' => 'increaseStock+'], ['text' => __('home_account'), 'callback_data' => 'myacc']],
            [['text' => __('home_?'), 'url' => 'https://t.me/TellgaminHelp/2'], ['text' => __('home_support'), 'url' => 'https://t.me/Tellgamin?direct']],
            [['text' => __('home_chan'), 'url' => 'https://t.me/tellgamin']],
            [['text' => __('home_admin'), 'callback_data' => 'admin']],
        ]]);
    } else {
        $home = json_encode(['inline_keyboard' => [
            [['text' => __('home_products'), 'callback_data' => 'shopmenu']],
            [['text' => __('home_increase_stock'), 'callback_data' => 'increaseStock+'], ['text' => __('home_account'), 'callback_data' => 'myacc']],
            [['text' => __('home_?'), 'url' => 'https://t.me/TellgaminHelp/2'], ['text' => __('home_support'), 'url' => 'https://t.me/Tellgamin?direct']],
            [['text' => __('home_chan'), 'url' => 'https://t.me/tellgamin']],
            [['text' => __('home_admin'), 'callback_data' => 'admin']],
        ]]);
    }
} else {
    if ($collection == "on") {

        $home = json_encode(['inline_keyboard' => [
            [['text' => __('home_products'), 'callback_data' => 'shopmenu']],
            [['text' => __('home_increase_stock'), 'callback_data' => 'increaseStock+'], ['text' => __('home_account'), 'callback_data' => 'myacc']],

            [['text' => __('home_?'), 'url' => 'https://t.me/TellgaminHelp/2'], ['text' => __('home_support'), 'url' => 'https://t.me/Tellgamin?direct']],
            [['text' => __('home_chan'), 'url' => 'https://t.me/tellgamin']],
        ]]);
    } else {
        $home = json_encode(['inline_keyboard' => [
            [['text' => __('home_products'), 'callback_data' => 'shopmenu']],
            [['text' => __('home_increase_stock'), 'callback_data' => 'increaseStock+'], ['text' => __('home_account'), 'callback_data' => 'myacc']],
            [['text' => __('home_?'), 'url' => 'https://t.me/TellgaminHelp/2'], ['text' => __('home_support'), 'url' => 'https://t.me/Tellgamin?direct']],
            [['text' => __('home_chan'), 'url' => 'https://t.me/tellgamin']],
        ]]);
    }
}

$pay_false = json_encode(['resize_keyboard' => true, 'keyboard' => [
    [['text' => __('pay_confirm_send_number'), 'request_contact' => true]],
    [['text' => __('back')]],
]]);

$back = json_encode(['resize_keyboard' => true, 'keyboard' => [
    [['text' => __('back')]],
]]);

$backInline = json_encode(['inline_keyboard' => [
    [['text' => __('back'), 'callback_data' => 'back']],
]]);
$backInline2 = json_encode(['inline_keyboard' => [
    [['text' => __('back'), 'callback_data' => 'back2']],
]]);
$backAdmin = json_encode(['resize_keyboard' => true, 'keyboard' => [
    [['text' => __('back')]],
]]);
$removeKeyBoard = json_encode(['remove_keyboard' => true]);
if ($lang == "fa") {
    $pay_true = json_encode(['inline_keyboard' => [
        [['text' => __('pay_rial'), 'callback_data' => 'payOffline'], ['text' => __('pay_crypto'), 'callback_data' => 'payCurrency']],
        [['text' => __('back'), 'callback_data' => 'back']],
    ]]);
} else {
    $pay_true = json_encode(['inline_keyboard' => [
        [['text' => __('pay_crypto'), 'callback_data' => 'payCurrency']],
        [['text' => __('back'), 'callback_data' => 'back']],
    ]]);
}
//===================== KEYBOARDS =====================\\

//===================== FUNCTIONS =====================\\
function sendLog($type, $text, $keyboard = null) {
    global $MahdyarEn, $adminGroupId, $topics;
    
    // پیدا کردن آیدی تاپیک بر اساس نوع گزارش
    $threadId = isset($topics[$type]) ? $topics[$type] : null;

    $params = [
        'chat_id' => $adminGroupId,
        'text' => $text,
        'parse_mode' => 'html',
        'disable_web_page_preview' => true
    ];

    // اگر تاپیک پیدا شد، پارامتر آن را اضافه کن
    if ($threadId) {
        $params['message_thread_id'] = $threadId;
    }

    // اگر کیبورد داشت اضافه کن
    if ($keyboard) {
        $params['reply_markup'] = $keyboard;
    }

    return $MahdyarEn->Sendmessage($params);
}

function getExempt()
{
    global $db;
    $result = [];
    $query = $db->query("SELECT * FROM settings WHERE `type` = 'exempt'")->fetch_assoc()["type_id"];
    if ($query != null) {
        $explode = explode('|', $query);
        for ($i = 0; $i < substr_count("{$query}", '|'); $i++) {
            array_push($result, $explode[$i]);
        }
    }
    return $result;
}
function checkJoin($from_id)
{
    global $db;
    global $MahdyarEn;
    $status = true;
    $channel = $db->query("SELECT * FROM settings WHERE `type` = 'channel'");
    while ($row = $channel->fetch_assoc()) {
        $chId = $row['type_id'];
        $nameCh = $row['columnOne'];
        $linkCh = $row['columnTwo'];
        $join = $MahdyarEn->getChatMember(['chat_id' => $chId, 'user_id' => $from_id])['result']['status'];

        if ($join != 'member' and $join != 'creator' and $join != 'administrator') {
            $key[] =  [['text' => $nameCh, 'url' => $linkCh]];
            $status = false;
        }
    }
    $key[] = [['text' => __('verify_join'), 'callback_data' => 'imjoined']];
    if ((in_array($from_id, getExempt()))) $status = true;
    return [$status, $key];
}
$chackJoin = checkJoin($from_id);


// get all lock channel form db => returns array
function getChannels()
{
    global $db;
    $query = $db->query("SELECT * FROM settings WHERE `type` = 'channel'");
    $result = [];
    while ($row = $query->fetch_assoc()) {
        array_push($result, $row['id']);
    }
    return $result;
}

function getAdmins($just = false)
{
    global $db, $admins;
    $query = $db->query("SELECT * FROM settings WHERE `type` = 'admin'")->fetch_assoc()["type_id"];
    $result = [];
    if (!$just) {
        foreach ($admins as $admin) {
            array_push($result, $admin);
        }
    }
    if ($query != null) {
        $explode = explode('|', $query);
        for ($i = 0; $i < substr_count("{$query}", '|'); $i++) {
            array_push($result, $explode[$i]);
        }
    }

    return $result;
}
function roundUp($number, $precision = 2)
{
    $factor = pow(10, $precision);
    return ceil($number * $factor) / $factor;
}

function checkUsername($username)
{
    $url = file_get_contents("https://t.me/$username");
    $pattern = '/<span dir="auto">(.*?)<\/span>/s';
    if (preg_match($pattern, $url, $matches)) {
        return "( <a href='https://t.me/$username'>$matches[1]</a> )";
    }
    return false;
}

function maskNumber($number)
{
    $numStr = (string)$number;
    $len = strlen($numStr);

    if ($len <= 5) {
        return $numStr;
    }
    $start = substr($numStr, 0, 2); // دو رقم اول
    $end = substr($numStr, -3); // سه رقم آخر
    $middle = str_repeat('*', $len - 5);
    return $start . $middle . $end;
}
function getBitpinDataByCode($code)
{
    $api_url = json_decode(file_get_contents("https://api.bitpin.ir/v1/mkt/markets/"), true);
    $data = $api_url['results'];
    foreach ($data as $item) {
        if (isset($item['code']) && $item['code'] === $code) {
            return $item;
        }
    }
    return null;
}

function __($key, $vars = [])
{
    global $lang, $botName, $EnBotName, $supportUsername, $channelUsername, $giftAccountUsername;
    if (!$lang) $lang = "fa";
    static $translations = null;
    if ($translations === null) {
        $translations = include __DIR__ . "/languages/{$lang}.php";
    }
    $text = $translations[$key] ?? $key;
    $globalPlaceholders = [
        '{botName}',
        '{EnBotName}',
        '{supportUsername}',
        '{channelUsername}',
        '{giftAccountUsername}'
    ];
    $globalValues = [
        $botName,
        $EnBotName,
        $supportUsername,
        $channelUsername,
        $giftAccountUsername
    ];
    $text = str_replace($globalPlaceholders, $globalValues, $text);

    foreach ($vars as $k => $v) {
        $text = str_replace("{" . $k . "}", $v, $text);
    }

    return $text;
}
function findItemById($dataArray, $targetId)
{
    foreach ($dataArray as $item) {
        if (isset($item['id']) && $item['id'] == $targetId) {
            return $item;
        }
    }

    // اگر حلقه تمام شود و چیزی پیدا نشود، null برمی‌گرداند
    return null;
}


function sendSMS($to, $code)
{

    $client = new SoapClient("https://api.payamak-panel.com/post/Send.asmx?wsdl", ["encoding" => "UTF-8"]);

    $params = [
        "username" => "09146948875",
        "password" => "Mahyar##2000",
        "text"     => "کد تایید شما در تلگامین: $code",
        "to"       => $to,
        "bodyId"   => 366625,
    ];

    $result = $client->SendByBaseNumber2($params);
    return $result;
}


//===================== FUNCTIONS =====================\\
if ($user['ban'] == 1) die;



// Add Lock channel
if (strpos($text, '/lock_') !== false && ($getchat['type'] == "supergroup" || $getchat['type'] == "channel" || $getchat['type'] == "group")) {
    $row = $db->query("SELECT * FROM user WHERE step LIKE '/lock_%' LIMIT 1;")->fetch_assoc();
    if ($row['step'] == $text) {
        $inviteLink = $MahdyarEn->createChatInviteLink(['chat_id' => $chat_id])['result']['invite_link'];
        if ($inviteLink) {
            $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
            $MahdyarEn->Sendmessage(['chat_id' => $row['id'], 'text' => "✅ قفل با موفقیت اضافه شد. \n\n👈 نوع قفل : <code>$channelType</code>\n✏️ نام : <code>$channelTitle</code>\n🔗 لینک : $inviteLink\n👈 ایدی عددی قفل : <code>$chat_id</code>\n‌", 'disable_web_page_preview' => true, 'parse_mode' => 'html', 'reply_markup' => $admin]);
            $db->multi_query("UPDATE user SET step = 'none+' WHERE id = '{$row['id']}';INSERT INTO `settings` (`type`, `type_id`, `columnOne`, `columnTwo`) VALUES ('channel', '$chat_id', '$channelTitle', '$inviteLink')");
            exit();
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $row['id'], 'text' => "⭕️ ربات دسترسی ساخت لینک را ندارد. لطفا دسترسی لازم را بدهید.", 'disable_web_page_preview' => true, 'parse_mode' => 'html']);
        }
    }
}
// تغییر: اضافه کردن شرط !isset($data) تا دکمه‌های شیشه‌ای در گروه‌ها هم کار کنند
if ($getchat['type'] != "private" && !in_array($from_id, getAdmins()) && !isset($data)) die;
// اگر پیام دکمه شیشه ای بود (!isset($data)) ربات متوقف نشود

// Checking join states
if ($data == "imjoined") {
    if (($chackJoin[0])) {
        $MahdyarEn->answerCallbackQuery([
            'callback_query_id' => $callback_id,
            'text' => __('joined_success'),
            'show_alert' => false
        ]);
        $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
        $MahdyarEn->Sendmessage([
            'chat_id' => $chat_id,
            'text' => __('joined_success'),
            'reply_markup' => $home
        ]);
    } else {
        $MahdyarEn->answerCallbackQuery([
            'callback_query_id' => $callback_id,
            'text' => __('join_not_yet'),
            'show_alert' => false
        ]);
        $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
        $MahdyarEn->Sendmessage([
            'chat_id' => $chat_id,
            'text' => __('join_required'),
            'disable_web_page_preview' => true,
            'reply_markup' => json_encode(['inline_keyboard' => $chackJoin[1]])
        ]);
    }
    exit();
}


// SUBSET

  // SUBSET (زیرمجموعه گیری و استارت با لینک)
if (preg_match('/^(\/start) (.*)/', $text, $match)) {

    if ($match[2] == "gift") {
        // بخش گیفت (دست نخورده)
        $key = json_encode(['inline_keyboard' => [
            [['text' => "🎁 گیفت های دائمی", 'callback_data' => 'permanentGifts1']],
            [['text' => "بازگشت 🔙", 'callback_data' => 'back']],
        ]]);
        $MahdyarEn->sendMessage(['chat_id' => $chat_id, 'text' => __('gift_txt_2'), 'reply_markup' => $key, 'parse_mode' => 'html']);
    } else {
        // پیام خوش‌آمدگویی به کاربر
        $MahdyarEn->Sendmessage([
            'chat_id' => $chat_id,
            'text' => __('welcome_text'),
            'reply_markup' => $home,
            'parse_mode' => "html"
        ]);

        // بررسی اینکه کاربر جدید است یا خیر
        if ($user['id'] != true) {
            // ثبت در دیتابیس
            $db->query("INSERT INTO user(id,signin,addStock,inviter) VALUES('$from_id','$timeU','no','$match[2]')");
            
            // --- ارسال لاگ به تاپیک ادمین (با لینک دعوت) ---
            $uName = $MahdyarEn->UserName();
            $userLink = $uName ? "@$uName" : "ندارد";
            $safeName = htmlspecialchars($firstname); // جلوگیری از خرابی HTML با اسم‌های عجیب
            $inviterID = $match[2];

            $logText = "👥 <b>عضو جدید (با لینک دعوت)</b>\n\n";
            $logText .= "👤 <b>نام:</b> <a href='tg://user?id=$from_id'>$safeName</a>\n";
            $logText .= "🆔 <b>آیدی:</b> <code>$from_id</code>\n";
            $logText .= "🔗 <b>یوزرنیم:</b> $userLink\n";
            $logText .= "──────────────\n";
            $logText .= "👤 <b>دعوت‌کننده:</b> <a href='tg://user?id=$inviterID'>$inviterID</a>\n";
            $logText .= "📅 <b>زمان:</b> $date2 | $time";

            sendLog('join', $logText);
            // ------------------------------------------------

            // اطلاع رسانی به دعوت کننده
            $usera = $db->query("SELECT * FROM user WHERE id = $match[2]")->fetch_assoc();
            if ($match[2] != null && $usera['id'] != false) {
                $MahdyarEn->Sendmessage([
                    'chat_id' => $match[2],
                    'text' => __('invited_success', ['amount' => number_format($invite)])
                ]);
            }
            
            // انتخاب زبان برای کاربر جدید
            $langg = json_encode(['inline_keyboard' => [
                [['text' => "Persian 🇮🇷", 'callback_data' => 'lang_fa'], ['text' => "English 🇺🇸", 'callback_data' => 'lang_en']],
                [['text' => "Русский 🇷🇺", 'callback_data' => 'lang_ru']],
            ]]);
            $MahdyarEn->Sendmessage([
                'chat_id' => $from_id,
                'text' => "🇮🇷جهت ادامه، لطفاً زبان خود را انتخاب کنید.\n\n🇺🇸 Please select your language to continue\n\n🇷🇺Пожалуйста, выберите язык, чтобы продолжить.",
                'parse_mode' => 'MarkDown',
                'reply_markup' => $langg
            ]);
        }
    }
    exit();
}

// User join (استارت عادی)
elseif (preg_match('/^\/(start)$/i', $text)) {
    $MahdyarEn->Sendmessage([
        'chat_id' => $chat_id,
        'text' => __('welcome_text'),
        'reply_markup' => $home,
        'parse_mode' => "html"
    ]);

    if (!$user['id']) {
        // ثبت در دیتابیس
        $db->query("INSERT INTO user(id,signin) VALUES('$from_id','$timeU')");

        // --- ارسال لاگ به تاپیک ادمین (استارت مستقیم) ---
        $uName = $MahdyarEn->UserName();
        $userLink = $uName ? "@$uName" : "ندارد";
        $safeName = htmlspecialchars($firstname);

        $logText = "🟢 <b>عضو جدید (استارت مستقیم)</b>\n\n";
        $logText .= "👤 <b>نام:</b> <a href='tg://user?id=$from_id'>$safeName</a>\n";
        $logText .= "🆔 <b>آیدی:</b> <code>$from_id</code>\n";
        $logText .= "🔗 <b>یوزرنیم:</b> $userLink\n";
        $logText .= "📅 <b>زمان:</b> $date2 | $time";

        sendLog('join', $logText);
        // ------------------------------------------------

        // انتخاب زبان
        $langg = json_encode(['inline_keyboard' => [
            [['text' => "Persian 🇮🇷", 'callback_data' => 'lang_fa'], ['text' => "English 🇺🇸", 'callback_data' => 'lang_en']],
            [['text' => "Русский 🇷🇺", 'callback_data' => 'lang_ru']],
        ]]);
        $MahdyarEn->Sendmessage([
            'chat_id' => $from_id,
            'text' => "🇮🇷جهت ادامه، لطفاً زبان خود را انتخاب کنید.\n\n🇺🇸 Please select your language to continue\n\n🇷🇺Пожалуйста, выберите язык, чтобы продолжить.",
            'parse_mode' => 'MarkDown',
            'reply_markup' => $langg
        ]);
    }
    exit();
// اضافه کردن شرط: اگر دکمه "بازگشت" یا "تایید جوین" بود، گیر ندهد
} elseif (!$chackJoin[0] and $getchat['type'] == 'private' && $data != 'back' && $data != 'back2' && $data != 'shopmenu') {
    $MahdyarEn->Sendmessage([
        'chat_id' => $chat_id,
        'text' => __('joined_error_message'),
        'disable_web_page_preview' => true,
        'reply_markup' => json_encode(['inline_keyboard' => $chackJoin[1]])
    ]);
    exit();
} elseif ($updateType && $user['id'] != true) {
    $db->query("INSERT INTO user(id,signin) VALUES('$from_id','$timeU')");
    $usera =  $db->query("SELECT * FROM user WHERE id = $match[2]")->fetch_assoc();

    $langg = json_encode(['inline_keyboard' => [
        [['text' => "Persian 🇮🇷", 'callback_data' => 'lang_fa'], ['text' => "English 🇺🇸", 'callback_data' => 'lang_en']],
        [['text' => "Русский 🇷🇺", 'callback_data' => 'lang_ru']],

    ]]);
    $MahdyarEn->Sendmessage([
        'chat_id' => $from_id,
        'text' => "🇮🇷جهت ادامه، لطفاً زبان خود را انتخاب کنید.

🇺🇸 Please select your language to continue

🇷🇺Пожалуйста, выберите язык, чтобы продолжить.",

        'parse_mode' => 'MarkDown',
        'reply_markup' => $langg
    ]);
}

// add stock to subset
if ($user['addStock'] == 'no') {
    $db->query("UPDATE user SET stock = stock+$invite, invite = invite+1  WHERE id = '{$user['inviter']}'");
    $db->query("UPDATE user SET step = 'none', addStock = 'yes'  WHERE id = '$from_id'");
    $MahdyarEn->Sendmessage(['chat_id' => $user['inviter'], 'text' => __('invite_reward', ['amount' => number_format($invite)]), 'reply_markup' => $home]);
    $MahdyarEn->Sendmessage(['chat_id' => $reportChannel, 'text' => "✨ کاربر [$chat_id](tg://user?id=$chat_id) توسط کاربر [{$user['inviter']}](tg://user?id={$user['inviter']}) به ربات پیوست", 'parse_mode' => 'MarkDown']);
}

require_once 'admin.php';

if ($botStatus['type_id'] == 'off' && !in_array($from_id, getAdmins())) {
    $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => __('bot_off'), 'reply_markup' => $home]);
    exit();
}

//=============== Handle Text ===============\\


switch ($text) {

    case "🔙 بازگشت":
        case "بازگشت 🔙":
        case "برگشت":
            // ریست کردن مرحله (Step) کاربر
            $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id' ");
    
            // اگر کاربر ادمین بود، پنل مدیریت باز شود
            if (in_array($from_id, getAdmins())) {
                $MahdyarEn->Sendmessage([
                    'chat_id' => $chat_id, 
                    'text' => "👤 به پنل مدیریت خوش آمدید، برای انجام عملیات یکی از دکمه های زیر را انتخاب کنید:\n‌", 
                    'reply_markup' => $admin
                ]);
            } 
            // در غیر این صورت (کاربر عادی)، منوی اصلی نمایش داده شود
            else {
                $MahdyarEn->Sendmessage([
                    'chat_id' => $chat_id, 
                    'text' => __('back_to_menu'), 
                    'reply_markup' => $home
                ]);
            }
            exit();
            break;

    case "/start gift":
        $explode = explode('_', $data);
        $key = json_encode(['inline_keyboard' => [
            [['text' => "🎁 گیفت های دائمی", 'callback_data' => 'permanentGifts1']],
            [['text' => "بازگشت 🔙", 'callback_data' => 'back']],

        ]]);
        $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => __('gift_txt_2'), 'reply_markup' => $key, 'parse_mode' => 'html']);
        break;

    case "/premium":
        $db->query("UPDATE user SET step = 'prem1' WHERE id = '$from_id' ");
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id,  'text' => __('send_premium_username'), 'reply_markup' => $backInline, 'parse_mode' => 'html']);
        break;


    case "/video":

        $x =         $db->query("SELECT * FROM settings WHERE `type` = 'video'");
        $_ = [];
        while ($row = $x->fetch_assoc()) {
            $_[] =   [
                "type" => "video",
                "media" => $row['type_id'],
                "caption" => $row['columnOne'],
            ];
        }
        if (count($_) >= 2) {
            $ll = $MahdyarEn->sendMediaGroup(['chat_id' => $chat_id, 'media' => json_encode($_), 'parse_mode' => 'html']);
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id,  'text' => 'ویدیویی تنظیم نشده است', 'reply_markup' => $home, 'parse_mode' => 'html']);
        }
        break;



    case "/lang":
        $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id' ");
        $langg = json_encode(['inline_keyboard' => [
            [['text' => "Persian 🇮🇷", 'callback_data' => 'lang_fa'], ['text' => "English 🇺🇸", 'callback_data' => 'lang_en']],
            [['text' => "Русский 🇷🇺", 'callback_data' => 'lang_ru']],

        ]]);
        $MahdyarEn->Sendmessage([
            'chat_id' => $from_id,
            'text' => "🇮🇷جهت ادامه، لطفاً زبان خود را انتخاب کنید.

🇺🇸 Please select your language to continue

🇷🇺Пожалуйста, выберите язык, чтобы продолжить.",

            'parse_mode' => 'MarkDown',
            'reply_markup' => $langg
        ]);
        exit();
        break;

// این قسمت را جایگزین case "/stars": قبلی کنید
case "/stars":
    // تعریف بسته‌های استارز
    $starPlans = [50, 100, 250, 500, 750, 1000]; 
    $buttons = [];
    $row = [];
    
    // ساخت دکمه‌های بسته‌ها (3 دکمه در هر ردیف)
    foreach ($starPlans as $amt) {
        $row[] = ['text' => "$amt ⭐️", 'callback_data' => "pre_star_$amt"];
        if (count($row) == 3) {
            $buttons[] = $row;
            $row = [];
        }
    }
    if (!empty($row)) $buttons[] = $row;
    
    // افزودن دکمه تعداد دلخواه و بازگشت
    $buttons[] = [['text' => "✏️ تعداد دلخواه", 'callback_data' => 'enter_custom_stars']];
    $buttons[] = [['text' => __('back'), 'callback_data' => 'back']];

    $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id' ");
    $MahdyarEn->Sendmessage([
        'chat_id' => $chat_id,  
        'text' => "✨ لطفاً یکی از بسته‌های استارز زیر را انتخاب کنید یا گزینه تعداد دلخواه را بزنید:", 
        'reply_markup' => json_encode(['inline_keyboard' => $buttons]), 
        'parse_mode' => 'html'
    ]);
    break;


    case "/collection":
        if (isset($data)) {
            $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
        }
        $MahdyarEn->Sendmessage([
            'chat_id' => $chat_id,
            'text' => __('collection_share', ['amount' => number_format($invite), 'bot_username' => $botusername, 'from_id' => $from_id]),
            'reply_markup' => json_encode(['inline_keyboard' => [
                [['text' => __('banner'), 'callback_data' => 'banner']],
            ]])
        ]);
        break;


    }

//=============== Handle Data ===============\\

switch ($data) {
    // هندل کردن انتخاب نوع خرید (خودم/دوست)
    
    // --- بخش پرمیوم ---
    case "select_type_prem_friend":
        $db->query("UPDATE user SET step = 'prem1' WHERE id = '$from_id' ");
        $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => __('send_premium_username'), 'reply_markup' => $backInline, 'parse_mode' => 'html']);
        break;

    case "select_type_prem_me":
        // برای "خودم"، یوزرنیم کاربر را میگیریم یا اگر نداشت از آیدی عددی استفاده میکنیم
        $target = $MahdyarEn->UserName(); 
        if(empty($target)) $target = $from_id;
        
        // نمایش مستقیم پلن‌ها (شبیه وقتی که یوزرنیم را دستی وارد کرده)
        $keyboard = json_encode(['inline_keyboard' => [
            [['text' => __("prem1_plan_3", ['price' => number_format($prem3)]), 'callback_data' => "prem*3months*$target"], ['text' => __("prem1_plan_6", ['price' => number_format($prem6)]), 'callback_data' => "prem*6months*$target"]],
            [['text' => __("prem1_plan_12", ['price' => number_format($prem12)]), 'callback_data' => "prem*12months*$target"]],
            [['text' => __("back"), 'callback_data' => 'buyPremium']], // برگشت به انتخاب پرمیوم
        ]]);
        
        $MahdyarEn->editMessageText([
            'chat_id' => $chat_id,
            'message_id' => $message_id,
            'text' => __("prem1_choose_plan", ['username' => $target]),
            'reply_markup' => $keyboard,
            'parse_mode' => 'html'
        ]);
        break;

    // --- بخش استارز ---
    case (strpos($data, 'select_type_star_') !== false):
        $exp = explode('_', $data); // [select, type, star, MODE, AMOUNT]
        $mode = $exp[3]; // me or friend
        $amount = $exp[4]; // amount
        
        if($mode == 'friend'){
            $db->query("UPDATE user SET step = 'star*$amount' WHERE id = '$from_id' ");
            $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => __("star1_ask_username"), 'reply_markup' => $backInline, 'parse_mode' => 'html']);
        } else {
            // خرید برای خودم
            $target = $MahdyarEn->UserName(); 
            if(empty($target)) $target = $from_id;
            
            // نمایش فاکتور نهایی (مشابه کد star*)
            $price = $amount * $starsPrice;
            $keyboard = json_encode(['inline_keyboard' => [
                [['text' => __('star2_button', ['stars' => $amount, 'price' => number_format($price)]), 'callback_data' => "star2*$amount*$target"]],
                [['text' => __('back'), 'callback_data' => 'buyStars']]
            ]]);
            
            $MahdyarEn->editMessageText([
                'chat_id' => $chat_id,
                'message_id' => $message_id,
                'text' => __('star2_confirm', ['username' => $target]),
                'reply_markup' => $keyboard,
                'parse_mode' => 'html'
            ]);
        }
        break;

    // --- بخش تون کوین ---
    case (strpos($data, 'select_type_ton_') !== false):
        $exp = explode('_', $data); // [select, type, ton, MODE, AMOUNT]
        $mode = $exp[3]; // me or friend
        $amount = $exp[4]; // amount
        
        if($mode == 'friend'){
            $db->query("UPDATE user SET step = 'ton*$amount' WHERE id = '$from_id' ");
            $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => __("ton_ask_username"), 'reply_markup' => $backInline, 'parse_mode' => 'html']);
        } else {
            // خرید برای خودم
            $target = $MahdyarEn->UserName(); 
            if(empty($target)) $target = $from_id;
            
            // نمایش فاکتور نهایی
            $price = $amount * $tonPrice;
            $keyboard = json_encode(['inline_keyboard' => [
                [['text' => __('ton_button', ['stars' => $amount, 'price' => number_format($price)]), 'callback_data' => "ton2*$amount*$target"]],
                [['text' => __('back'), 'callback_data' => 'buyTon']]
            ]]);
            
            $MahdyarEn->editMessageText([
                'chat_id' => $chat_id,
                'message_id' => $message_id,
                'text' => __('ton_confirm', ['username' => $target]),
                'reply_markup' => $keyboard,
                'parse_mode' => 'html'
            ]);
        }
        break;

    case "back":
        // $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
        $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => __('back_to_menu'), 'reply_markup' => $home]);
        $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id' ");
        exit();
        break;

        case "backAdmin":
            if (in_array($from_id, getAdmins())) {
                $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id - 1]);
                $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => __('back_to_menu'), 'reply_markup' => $panel]);
            } else {
                // اگر کاربر عادی اشتباهاً به این دکمه رسید، به منوی اصلی برود
                $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => __('back_to_menu'), 'reply_markup' => $home]);
            }
            $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id' ");
            exit();
            break;

            case "back2":
                // استفاده از @ برای جلوگیری از ارور اگر پیام قبلی وجود نداشت
                @$MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id - 1]);
                
                $MahdyarEn->editMessageText([
                    'chat_id' => $chat_id, 
                    'message_id' => $message_id, 
                    'text' => __('back_to_menu'), 
                    'reply_markup' => $home
                ]);
                
                // پاسخ به کالبک برای جلوگیری از لودینگ
                $MahdyarEn->answerCallbackQuery([
                    'callback_query_id' => $callback_id,
                    'text' => '',
                ]);
                
                $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id' ");
                exit();
                break;
    case "cancelSending":
        $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
        $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "✅ صف ارسال پیام با موفقیت خالی شد اکنون میتوانید پیام خود را دوباره بفرستید", 'reply_markup' => $admin]);
        $db->query("UPDATE sendall SET step = '' , `text` = '' , user = '0' , `block` = '0' , chat = '', `type` = '', MsgId = '' , ChatID = ''");
        $db->query("UPDATE user SET step = '' WHERE id = '$from_id'");
        exit();
        break;

    case "none":
        $MahdyarEn->answerCallbackQuery(['callback_query_id' => $callback_id, 'text' => "این دکمه نمایشی می باشد", 'show_alert' => true]);
        break;

    case "unlimited":
        $MahdyarEn->answerCallbackQuery(['callback_query_id' => $callback_id, 'text' => "موجودی باقیمانده: نامحدود", 'show_alert' => true]);
        break;

        case "myacc":
            // 1. دریافت اطلاعات تکمیلی از دیتابیس
            // تعداد کل سفارش‌های موفق کاربر
            $ordersCount = $db->query("SELECT id FROM orders WHERE buyer = '$from_id' AND stats = 'completed'")->num_rows;
            
            // تعداد زیرمجموعه‌های کاربر
            // (فرض بر این است که جدول referrals دارید، اگر نه از جدول user و ستون inviter استفاده کنید)
            $subsetCount = $db->query("SELECT id FROM referrals WHERE referrer_id = '$from_id'")->num_rows; 
            
            // فرمت کردن موجودی
            $formattedStock = number_format($stock);
            
            // موجودی پاداش رفرال (اگر ستونش را اضافه کردید)
            $refBalance = isset($user['ref_stars_balance']) ? number_format($user['ref_stars_balance'], 2) : '0';
    
            // 2. ساخت متن جذاب و کامل
            $msg = "👤 <b>اطلاعات حساب کاربری شما</b>\n\n";
            $msg .= "👤 <b>نام:</b> " . htmlspecialchars($firstname) . "\n";
            $msg .= "📱 <b>شماره موبایل:</b> $phone\n";
            $msg .= "📅 <b>تاریخ عضویت:</b> $dayStart\n";
            
            $msg .= "\n➖➖ <b>کیف پول و آمار</b> ➖➖\n";
            $msg .= "💰 <b>موجودی تومانی:</b> $formattedStock تومان\n";
            $msg .= "🌟 <b>پاداش رفرال:</b> $refBalance استارز\n";
            $msg .= "🛍 <b>تعداد سفارشات موفق:</b> $ordersCount عدد\n";
            $msg .= "👥 <b>تعداد زیرمجموعه:</b> $subsetCount نفر\n";
            
            $msg .= "\n⏰ <i>بروزرسانی: $time - $date</i>";
    
            // 3. کیبورد دسترسی سریع (خیلی کاربردی‌تر از فقط دکمه بازگشت)
            $accButtons = json_encode(['inline_keyboard' => [
                [
                    ['text' => __('home_history'), 'callback_data' => 'orderHistory'],
                    ['text' => __('home_track'), 'callback_data' => 'trackOrder']
                ],
                [
                    ['text' => "🔙 بازگشت", 'callback_data' => 'back']
                ]
            ]]);
    
            // 4. ویرایش پیام
            $MahdyarEn->editMessageText([
                'chat_id' => $chat_id, 
                'message_id' => $message_id, 
                'text' => $msg, 
                'parse_mode' => 'html', 
                'reply_markup' => $accButtons
            ]);
            break;

    case "shopmenu":
        $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);

        $btn = json_encode([
            'inline_keyboard' => [
                
                    [['text' => __('buyStars'), 'callback_data' => 'buyStars']],
                    [['text' =>  __('buyPremium'), 'callback_data' => 'buyPremium']],
                    [['text' =>  __('buyTon'), 'callback_data' => 'buyTon']],
                    [['text' =>  __('buyGifts'), 'callback_data' => 'buyBoost']],
                [
                    ['text' =>  __('back_btn'), 'callback_data' => 'back']
                ]
            ]
        ]);

        $MahdyarEn->sendMessage([
            'text' => __('choose_product'),
            'chat_id' => $chat_id,
            'message_id' => $message_id,
            'reply_markup' => $btn
        ]);
        break;


    case "info":
        $btn = json_encode(['inline_keyboard' => [
            [['text' => __('rules'), 'callback_data' => 'rules'], ['text' => __('help'), 'callback_data' => 'help']],
            [['text' => __('back_btn'), 'callback_data' => 'back']],

        ]]);
        $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => __('choose_txt'), 'parse_mode' => 'html', 'reply_markup' => $btn]);
        break;

    case "rules":
        $btn = json_encode(['inline_keyboard' => [
            [['text' => __('back_btn'), 'callback_data' => 'info']],

        ]]);
        $MahdyarEn->editMessageText([
            'chat_id' => $chat_id,
            'message_id' => $message_id,
            'text' => __('rules_text'),
            'parse_mode' => 'html',
            'reply_markup' => $btn
        ]);
        break;

    case "help":
        $btn = json_encode(['inline_keyboard' => [
            [['text' => __('back'), 'callback_data' => 'info']],

        ]]);
        $MahdyarEn->editMessageText([
            'disable_web_page_preview' => true,
            'chat_id' => $chat_id,
            'message_id' => $message_id,
            'text' => __('help_text'),
            'parse_mode' => 'html',
            'reply_markup' => $btn
        ]);
        break;



    case "trackOrder":
        $db->query("UPDATE user SET step = 'trackOrder' WHERE id = '$from_id' ");
        $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => __('track_order_text'), 'parse_mode' => 'html', 'reply_markup' => $backInline]);
        break;



   case "orderHistory":
        case (preg_match('/^history_page_(\d+)$/', $data, $match) ? true : false):
        
            // 1. شمارش کل سفارشات معتبر
            $count_query = $db->query("SELECT COUNT(*) as total_count FROM orders WHERE buyer = '$from_id' AND stats != 'waiting_pay' AND stats != 'expired'");
            $count_res = $count_query->fetch_assoc();
            $total_count = $count_res['total_count'] ?? 0;
    
            // 🛑 پاپ‌آپ اگر سفارشی نبود
            if ($total_count == 0) {
                $MahdyarEn->answerCallbackQuery([
                    'callback_query_id' => $callback_id,
                    'text' => "📭 شما هنوز هیچ سفارشی ثبت نکرده‌اید!",
                    'show_alert' => true
                ]);
                break; 
            }
    
            // 2. تنظیمات صفحه‌بندی
            $page = isset($match[1]) ? intval($match[1]) : 1;
            $items_per_page = 5;
            $total_pages = ceil($total_count / $items_per_page); // محاسبه کل صفحات
            $offset = ($page - 1) * $items_per_page;
    
            // 3. دریافت آمار مالی
            $sum_query = $db->query("SELECT SUM(price) as total_spent FROM orders WHERE buyer = '$from_id' AND stats != 'waiting_pay' AND stats != 'expired'");
            $total_spent = number_format($sum_query->fetch_assoc()['total_spent'] ?? 0);
    
            // 4. دریافت سفارشات این صفحه
            $orders = $db->query("SELECT * FROM orders WHERE buyer = '$from_id' AND stats != 'waiting_pay' AND stats != 'expired' ORDER BY id DESC LIMIT $items_per_page OFFSET $offset");
    
            // 5. ساخت هدر پیام
            $msg = "🛍 <b>تاریخچه خریدهای شما</b>\n\n";
            $msg .= "💳 <b>مجموع پرداختی:</b> $total_spent تومان\n";
            $msg .= "📦 <b>تعداد کل سفارشات:</b> $total_count عدد\n";
            $msg .= "────────────────────\n\n";
    
            // 6. حلقه ساخت لیست سفارشات
            while ($row = $orders->fetch_assoc()) {
                // وضعیت با گرافیک بهتر
                $status = $row['stats'];
                if ($status == 'completed') {
                    $status_icon = "🟢"; $status_txt = "تکمیل شده";
                } elseif ($status == 'processing') {
                    $status_icon = "🟡"; $status_txt = "در حال انجام";
                } elseif ($status == 'rejected') {
                    $status_icon = "🔴"; $status_txt = "رد شده";
                } else {
                    $status_icon = "⚪️"; $status_txt = "نامشخص";
                }
                
                // تمیز کردن نام محصول
                $details = explode('|', $row['name']);
                $pName = $details[0];
                $val = isset($details[1]) ? $details[1] : '';
                
                // ترجمه نام محصول
                $pDisplay = $pName;
                if ($pName == 'PREM') $pDisplay = "پرمیوم تلگرام ($val)";
                if ($pName == 'STAR') $pDisplay = "استارز ($val عدد)";
                if ($pName == 'TON')  $pDisplay = "تون کوین ($val TON)";
                if ($pName == 'GIFT') $pDisplay = "گیفت ($val عدد)";
                
                // بدنه هر آیتم
                $msg .= "$status_icon <b>$pDisplay</b>\n";
                $msg .= "🔖 کد: <code>{$row['id']}</code>\n";
                $msg .= "💰 " . number_format($row['price']) . " تومان | 📅 {$row['date']}\n";
                $msg .= " وضعیت: <b>$status_txt</b>\n";
                $msg .= "〰️〰️〰️〰️〰️〰️〰️〰️\n";
            }
    
            // 7. ساخت دکمه‌های صفحه‌بندی (نوار پایین)
            $nav_row = [];
            
            // دکمه قبلی
            if ($page > 1) {
                $prev_page = $page - 1;
                $nav_row[] = ['text' => "◀️", 'callback_data' => "history_page_$prev_page"];
            } else {
                $nav_row[] = ['text' => "⛔️", 'callback_data' => "none"]; // دکمه غیرفعال
            }
            
            // شماره صفحه (فقط نمایشی)
            $nav_row[] = ['text' => "📄 $page از $total_pages", 'callback_data' => "none"];
    
            // دکمه بعدی
            if ($page < $total_pages) {
                $next_page = $page + 1;
                $nav_row[] = ['text' => "▶️", 'callback_data' => "history_page_$next_page"];
            } else {
                $nav_row[] = ['text' => "⛔️", 'callback_data' => "none"];
            }
    
            // چیدن دکمه‌ها
            $buttons = [];
            $buttons[] = $nav_row; // ردیف نویگیشن
            $buttons[] = [['text' => "🔄 بروزرسانی وضعیت", 'callback_data' => "history_page_$page"]]; // دکمه رفرش
            $buttons[] = [['text' => __('back'), 'callback_data' => 'back']]; // دکمه بازگشت
    
            // 8. ارسال پیام
            $MahdyarEn->editMessageText([
                'chat_id' => $chat_id,
                'message_id' => $message_id,
                'text' => $msg,
                'parse_mode' => 'html',
                'reply_markup' => json_encode(['inline_keyboard' => $buttons])
            ]);
            break;


    case "increaseStock+":
        $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);

        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => __('increase_stock_txt'), 'reply_markup' => $pay_true]);

        break;

        case "buyPremium":
            // کیبورد انتخاب نوع خرید
            $key = json_encode(['inline_keyboard' => [
                [
                  ['text' => "👤 خرید برای خودم", 'callback_data' => 'select_type_prem_me'],
                  ['text' => "🎁 هدیه به دوست", 'callback_data' => 'select_type_prem_friend']
                ],
                [['text' => __('back'), 'callback_data' => 'back']]
            ]]);
            
            $MahdyarEn->editMessageText([
                'chat_id' => $chat_id, 
                'message_id' => $message_id, 
                'text' => "🛍 قصد خرید پرمیوم برای چه کسی را دارید؟", 
                'reply_markup' => $key, 
                'parse_mode' => 'html'
            ]);
            break;

// 1. کیس buyStars را با کد زیر جایگزین کنید:
case "buyStars":
    $starPlans = [50, 100, 250, 500, 750, 1000]; // مقادیر پلن‌ها
    $buttons = [];
    $row = [];
    
    foreach ($starPlans as $amt) {
        $row[] = ['text' => "$amt ⭐️", 'callback_data' => "pre_star_$amt"];
        if (count($row) == 3) {
            $buttons[] = $row;
            $row = [];
        }
    }
    if (!empty($row)) $buttons[] = $row;
    
    $buttons[] = [['text' => "✏️ تعداد دلخواه", 'callback_data' => 'enter_custom_stars']];
    $buttons[] = [['text' => __('back'), 'callback_data' => 'shopmenu']]; // بازگشت به منوی فروشگاه

    // استپ را خالی می‌کنیم تا تداخلی پیش نیاید
    $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id' ");
    
    $MahdyarEn->editMessageText([
        'chat_id' => $chat_id, 
        'message_id' => $message_id, 
        'text' => "✨ لطفاً یکی از بسته‌های استارز زیر را انتخاب کنید یا گزینه تعداد دلخواه را بزنید:", 
        'reply_markup' => json_encode(['inline_keyboard' => $buttons]), 
        'parse_mode' => 'html'
    ]);
    break;

// 2. کالبک جدید برای دکمه "تعداد دلخواه" (این کد را به switch($data) اضافه کنید)
case "enter_custom_stars":
    $db->query("UPDATE user SET step = 'star1' WHERE id = '$from_id' ");
    // دکمه بازگشت در اینجا باید کاربر را به لیست پلن‌ها (buyStars) برگرداند
    $backToPlans = json_encode(['inline_keyboard' => [
        [['text' => __('back'), 'callback_data' => 'buyStars']]
    ]]);
    
    $MahdyarEn->editMessageText([
        'chat_id' => $chat_id, 
        'message_id' => $message_id, 
        'text' => __('send_stars_amount'), // متن: لطفا تعداد را وارد کنید
        'reply_markup' => $backToPlans, 
        'parse_mode' => 'html'
    ]);
    break;

// 3. کالبک جدید برای انتخاب پلن‌های آماده (این کد را به switch($data) اضافه کنید)
case (strpos($data, 'pre_star_') !== false):
    $amount = explode('_', $data)[2]; // استخراج مقدار استارز انتخاب شده
    
    // نمایش مستقیم انتخاب نوع خرید (خودم/دوست) بدون نیاز به تایپ کردن
    $key = json_encode(['inline_keyboard' => [
        [
            ['text' => "👤 خرید برای خودم", 'callback_data' => "select_type_star_me_$amount"],
            ['text' => "🎁 هدیه به دوست", 'callback_data' => "select_type_star_friend_$amount"]
    ],
        [['text' => __('back'), 'callback_data' => 'buyStars']]
    ]]);

    $MahdyarEn->editMessageText([
        'chat_id' => $chat_id,
        'message_id' => $message_id,
        'text' => "⭐️ شما بسته <b>$amount</b> استارز را انتخاب کردید.\nقصد خرید برای چه کسی را دارید؟",
        'reply_markup' => $key,
        'parse_mode' => 'html'
    ]);
    break;

    case "buyTon":
        $db->query("UPDATE user SET step = 'ton1' WHERE id = '$from_id' ");
        $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => __('send_ton_amount'), 'reply_markup' => $backInline, 'parse_mode' => 'html']);
        break;

    case "buyBoost":
        $MahdyarEn->answerCallbackQuery(['callback_query_id' => $callback_id, 'text' => "بزودی !", 'show_alert' => true]);

        break;


    case "buyGifts":
        $explode = explode('_', $data);
        $key = json_encode(['inline_keyboard' => [
            [['text' => "🎁 گیفت های دائمی", 'callback_data' => 'permanentGifts1']], 
            [['text' => "بازگشت 🔙", 'callback_data' => 'back']],

        ]]);
        $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => __('gift_txt_2'), 'reply_markup' => $key, 'parse_mode' => 'html']);
        break;

    case "permanentGifts1":
        $explode = explode('_', $data);
        $key = json_encode(['inline_keyboard' => [
            [['text' => "ارسال کردم ✅", 'callback_data' => 'permanentGifts'], ['text' => "ارسال پیام", 'url' => "https://t.me/$giftAccountUsername"]],
            [['text' => "بازگشت 🔙", 'callback_data' => 'back']],

        ]]);
        $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => __('gift_txt_1'), 'reply_markup' => $key, 'parse_mode' => 'html']);
        break;

    case "limitedGifts1":
        $explode = explode('_', $data);
        $key = json_encode(['inline_keyboard' => [
            [['text' => "ارسال کردم ✅", 'callback_data' => 'limitedGifts'], ['text' => "ارسال پیام", 'url' => "https://t.me/$giftAccountUsername"]],
            [['text' => "بازگشت 🔙", 'callback_data' => 'back']],

        ]]);
        $x = json_decode(file_get_contents('gift_bot/gifts.json'), true);

        $ok = false;
        foreach ($x as $row) {
            if ($row['available_amount'] === null) continue;
            $ok = true;
            break;
        }
        if ($ok) {
            $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => __('gift_txt_1'), 'reply_markup' => $key, 'parse_mode' => 'html']);
        } else {
            $MahdyarEn->answerCallbackQuery(['callback_query_id' => $callback_id, 'text' => "درحال حاضر گیفت محدودی موجود نمی باشد", 'show_alert' => true]);
        }
        break;

    // case "buyGifts2":
    //     $explode = explode('_', $data);
    //     $key = json_encode(['inline_keyboard' => [
    //         [['text' => "🎁 گیفت های دائمی", 'callback_data' => 'permanentGifts'], ['text' => "🎁 گیفت های محدود", 'callback_data' => 'limitedGifts']],
    //         [['text' => "بازگشت 🔙", 'callback_data' => 'back']],

    //     ]]);
    //     $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => __('gift_txt_2'), 'reply_markup' => $key, 'parse_mode' => 'html']);
    //     break;

    case "limitedGifts":
        $explode = explode('_', $data);
        // @$giftsList = $db->query("SELECT * FROM `gifts` ORDER BY `gifts`.`stars` ASC");
        $x = json_decode(file_get_contents('gift_bot/gifts.json'), true);
        $key[] = [['text' => "Gift 🎁", 'callback_data' => "none"], ['text' => "Price 💳", 'callback_data' => "none"]];
        $ok = false;
        foreach ($x as $row) {
            if ($row['available_amount'] === null) continue;
            $ok = true;

            $key[] = [['text' => $row['sticker']['emoji'] . " " . $row["price"] . " ⭐️", 'callback_data' => "buyGift2*{$row['id']}"], ['text' => number_format($row["price"] * $starsPrice) . " T", 'callback_data' => "unlimited"]];
        }

        $key[] = [['text' => __('back'), 'callback_data' => "back2"]];

        if ($ok) {
            $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => __('choose_gift_limited'), 'reply_markup' => json_encode(['inline_keyboard' => $key]), 'parse_mode' => 'html']);
        } else {
            $MahdyarEn->answerCallbackQuery(['callback_query_id' => $callback_id, 'text' => "درحال حاضر گیفت محدودی موجود نمی باشد", 'show_alert' => true]);
        }
        break;



    case "permanentGifts":
        $explode = explode('_', $data);
        // @$giftsList = $db->query("SELECT * FROM `gifts` ORDER BY `gifts`.`stars` ASC");
        $x = json_decode(file_get_contents('gift_bot/gifts.json'), true);
        usort($x, function ($a, $b) {
            return $a['price'] <=> $b['price'];
        });
        $key[] = [['text' => "Gift 🎁", 'callback_data' => "none"], ['text' => "Price 💳", 'callback_data' => "none"]];
        foreach ($x as $row) {
            if ($row['available_amount'] !== null) continue;
            $key[] = [['text' => $row['sticker']['emoji'] . " " . $row["price"] . " ⭐️", 'callback_data' => "buyGift2*{$row['id']}"], ['text' => number_format($row["price"] * $starsPrice) . " T", 'callback_data' => "unlimited"]];
        }
        $key[] = [['text' => __('back'), 'callback_data' => "back2"]];

        $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => __('choose_gift'), 'reply_markup' => json_encode(['inline_keyboard' => $key]), 'parse_mode' => 'html']);

        break;


    case "support":
        $btn = json_encode(['inline_keyboard' => [
            [['text' => __('support'), 'url' => "https://t.me/$supportUsername"], ['text' => __('rules_help'), 'callback_data' => 'info']],
            [['text' => __('back_btn'), 'callback_data' => 'back']],
        ]]);
        $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => __('support_text'), 'reply_markup' => json_encode(['inline_keyboard' => $button]), 'parse_mode' => 'html', 'reply_markup' => $btn]);
        break;

    case "subset":
        $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
        $MahdyarEn->Sendmessage([
            'chat_id' => $chat_id,
            'text' => __('collection_share', ['amount' => number_format($invite), 'bot_username' => $botusername, 'from_id' => $from_id]),
            'reply_markup' => json_encode(['inline_keyboard' => [
                [['text' => __('banner'), 'callback_data' => 'banner']],
            ]])
        ]);
        break;

    case "banner":
        $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
        $MahdyarEn->sendPhoto(['chat_id' => $chat_id, 'photo' => new CURLFile("files/banner.jpg"), 'caption' => __('subset_txt', ['bot_username' => $botusername, 'from_id' => $from_id]), 'parse_mode' => 'html']);
        // $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => __('back_to_menu'), 'reply_markup' => $home]);
        break;

    case "admin":
        if ((in_array($from_id, getAdmins()))) {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "👤 به پنل مدیریت خوش آمدید، برای انجام عملیات یکی از دکمه های زیر را انتخاب کنید:\n‌", 'reply_markup' => $admin]);
        }
        break;

    case "noimnot":
        $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "👈 عملیات لغو شد، یکی از گزینه های زیر را انتخاب کنید:", 'reply_markup' => $admin]);
        $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id' ");
        exit();
        break;

    case "payOffline":
        $pay_card = $db->query("SELECT * FROM settings WHERE `type` = 'card'")->fetch_assoc();

        if ($pay_card['type_id'] == "on") {
            if ($user['phone'] == "") {
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "🔐 جهت احراز هویت و افزایش امنیت پرداخت‌ها:
لطفاً شماره موبایل خود را از طریق دکمه زیر ارسال کنید.

(اطلاعات شما نزد ما محفوظ خواهد ماند.‌)‌", 'reply_markup' => $pay_false]);
                $db->query("UPDATE user SET step = 'phone+' WHERE id = '$from_id' ");
            } else {

                $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => "مبلغ افزایش موجودی 💰
را بین 60,000 تا 3,000,000 تومان وارد کنید.

✅ پس از پرداخت، فیش را ارسال کنید تا تایید شود.", 'reply_markup' => $backInline]);
                $db->query("UPDATE user SET step = 'payOffline' WHERE id = '$from_id' ");
            }
        } else {
            $MahdyarEn->answerCallbackQuery(['callback_query_id' => $callback_id, 'text' => "درحال حاضر کارت به کارت فعال نمی‌باشد", 'show_alert' => false]);
        }

        break;


    case "addCh+":
        $random = $MahdyarEn->random();
        $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
        $db->query("UPDATE user SET step = '/lock_$random' WHERE id = '$from_id'");
        $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "برای افزودن قفل(کانال یا گروه) طبق مراحل زیر پیش بروید👇\n\n1️⃣ ربات را در (کانال یا گروه) مورد نظر ادمین کنید.\n2️⃣ دستور زیر را کپی و در (کانال یا گروه) ارسال کنید.\n<code>/lock_$random</code>\n☑️ اگر پیام شما حذف شد به معنای اضافه شدن کانال شما است.", 'parse_mode' => 'html', 'reply_markup' =>  $back]);
        break;


    // case "verify":
    //     $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "شماره کارتتون رو ارسال کنید به صورت لاتین", 'reply_markup' => $backInline]);
    //     $db->query("UPDATE user SET step = 'verify' WHERE id = '$from_id' ");
    //     break;



    case "payCurrency":
        $pay_card = $db->query("SELECT * FROM settings WHERE `type` = 'cur'")->fetch_assoc();

        if ($pay_card['type_id'] == "on") {
            $pay = json_encode(['inline_keyboard' => [
                [['text' => __('trx_pay'), 'callback_data' => 'payCurrency_trx']],
                [['text' => __('ton_pay'), 'callback_data' => 'payCurrency_ton']],
                [['text' => __('back_btn'), 'callback_data' => 'increaseStock+']],
            ]]);
            $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => __('payCurrency_choose'), 'reply_markup' => $pay]);
        } else {
            $MahdyarEn->answerCallbackQuery(['callback_query_id' => $callback_id, 'text' => __('payment_a'), 'show_alert' => false]);
        }
        break;
}
//=============== Handle Step ===============\\

switch ($step) {

    case "prem1":
        if (preg_match('/@?([a-zA-Z0-9_]{5,})/', $text)) {
            $text = str_replace("@", "", $text);
            $username = checkUsername($text);
            $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id' ");

            $keyboard = json_encode(['inline_keyboard' => [
                [['text' => __("prem1_plan_3", ['price' => number_format($prem3)]), 'callback_data' => "prem*3months*$text"], ['text' => __("prem1_plan_6", ['price' => number_format($prem6)]), 'callback_data' => "prem*6months*$text"]],
                [['text' => __("prem1_plan_12", ['price' => number_format($prem12)]), 'callback_data' => "prem*12months*$text"]],
                [['text' => __("back"), 'callback_data' => 'back']],
            ]]);

            $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);

            if ($username) {
                $MahdyarEn->SendMessage([
                    'chat_id' => $chat_id,
                    'text' => __("prem1_choose_plan", ['username' => $username]),
                    'reply_markup' => $keyboard,
                    'parse_mode' => 'html',
                    'disable_web_page_preview' => true,

                ]);
            } else {
                $MahdyarEn->SendMessage([
                    'chat_id' => $chat_id,
                    'text' => __("prem1_invalid_username"),
                    'reply_markup' => $backInline,
                    'parse_mode' => 'html'
                ]);
            }
        } else {
            $MahdyarEn->SendMessage([
                'chat_id' => $chat_id,
                'text' => __("prem1_invalid_username"),
                'reply_markup' => $backInline,
                'parse_mode' => 'html'
            ]);
        }
        break;

        case "star1":
            if ($text >= 50 && $text <= 1000000 && is_numeric($text)) {
                // ذخیره مرحله به همراه مبلغ وارد شده
                // اما هنوز درخواست آیدی نمیکنیم، اول میپرسیم برای کی
                $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id' "); // استپ را موقت برمیداریم تا دکمه کار کند
                
                $key = json_encode(['inline_keyboard' => [
                    [
                        ['text' => "👤 خرید برای خودم", 'callback_data' => "select_type_star_me_$text"],
                        ['text' => "🎁 هدیه به دوست", 'callback_data' => "select_type_star_friend_$text"]
                    ],
                    [['text' => __('back'), 'callback_data' => 'back']]
                ]]);
    
                $MahdyarEn->SendMessage([
                    'chat_id' => $chat_id,
                    'text' => "⭐️ شما مبلغ $text استارز را انتخاب کردید.\nقصد خرید برای چه کسی را دارید؟",
                    'reply_markup' => $key,
                    'parse_mode' => 'html'
                ]);
            } else {
                $MahdyarEn->SendMessage([
                    'chat_id' => $chat_id,
                    'text' => __("star1_invalid_amount"),
                    'reply_markup' => $backInline
                ]);
            }
            break;

            case "ton1":
                if ($text >= 0.1 && $text <= 100 && is_numeric($text)) {
                     $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id' ");
                     
                     $key = json_encode(['inline_keyboard' => [
                        [
                            ['text' => "👤 خرید برای خودم", 'callback_data' => "select_type_ton_me_$text"],
                            ['text' => "🎁 هدیه به دوست", 'callback_data' => "select_type_ton_friend_$text"]
                        ],
                        [['text' => __('back'), 'callback_data' => 'back']]
                    ]]);
        
                    $MahdyarEn->SendMessage([
                        'chat_id' => $chat_id,
                        'text' => "💎 شما مبلغ $text تون کوین را انتخاب کردید.\nقصد خرید برای چه کسی را دارید؟",
                        'reply_markup' => $key,
                        'parse_mode' => 'html'
                    ]);
                } else {
                    $MahdyarEn->SendMessage([
                        'chat_id' => $chat_id,
                        'text' => __("ton_invalid_amount"),
                        'reply_markup' => $backInline
                    ]);
                }
                break;

    case "trackOrder":
        $order = $db->query("SELECT * FROM orders WHERE id = '$text'");
        if ($order->num_rows == 0) {
            $MahdyarEn->SendMessage([
                'chat_id' => $chat_id,
                'text' => __("trackOrder_not_found"),
                'reply_markup' => $backInline
            ]);
        } else {
            $order = $order->fetch_assoc();
            $stats = $order['stats'] == 'waiting' ? __('is_pending') : __('is_done');
            $MahdyarEn->SendMessage([
                'chat_id' => $chat_id,
                'text' => __("trackOrder_info", [
                    'id' => $order['id'],
                    'name' => $order['name'],
                    'username' => $order['username'],
                    'date' => $order['date'],
                    'price' => number_format($order['price']),
                    'stats' => $stats
                ]),
                'parse_mode' => 'html',
                'reply_markup' => $backInline
            ]);
        }
        break;

    // verify user phone number
    case "phone+":
        if ($contact) {
            if ($contactho == $from_id) {
                $contactnum = str_replace('+', '', $contactnum);
                if ($contactnum[0] . $contactnum[1] == "98") {

                    $exp = 0;
                    if ($user['otp']) $exp = explode('-', $user['otp'])[2];

                    if ($exp < time()) {
                        $_ = $MahdyarEn->sendMessage(['chat_id' => $chat_id, 'text' => "⌛️ درحال ارسال کد تایید ...", 'parse_mode' => 'html'])['result']['message_id'];


                        $phone =  str_replace('98', '0', $contactnum);
                        $code = rand(100000, 999999);
                        $res = sendSMS($phone, $code);
                        $expire = time() + 60 * 10;
                        if ($res->SendByBaseNumber2Result) {
                            $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $_]);
                            $logText = "📨 <b>ارسال کد تایید (OTP)</b>\n";
                            $logText .= "────────────────\n";
                            $logText .= "👤 <b>درخواست کننده:</b> <a href='tg://user?id=$from_id'>" . htmlspecialchars($firstname) . "</a>\n";
                            $logText .= "📱 <b>شماره موبایل:</b> `$phone`\n";
                            $logText .= "🔑 <b>کد ارسال شده:</b> <code>$code</code>\n"; // نمایش کد به ادمین برای پشتیبانی احتمالی
                            $logText .= "📅 <b>زمان:</b> $date2 | $time";
                            
                            sendLog('otp', $logText);
                            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "✅ یک کد 6 رقمی به شماره شما ارسال شد. لطفاً آن را وارد کنید (درصورت لغو عملیات تا 10 دقیقه امکان دریافت کد جدید ندارید)", 'reply_markup' => $back]);
                            $db->query("UPDATE user SET step = 'phone++', otp = '$phone-$code-$expire-0' WHERE id = '$from_id' ");
                        } else {
                            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ مشکلی در ارسال کد پیش آمده لطفا به پشتیبانی اطلاع دهید\n/start", 'reply_markup' => $removeKeyBoard]);
                        }
                    } else {
                        $seconds = $exp - time();
                        $minutes = floor($seconds / 60);
                        $seconds = $seconds % 60;
                        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ خطا شما تا $minutes دقیقه و $seconds ثانیه دیگر نمیتوانید کد جدید بگیرید\n/start", 'reply_markup' => $removeKeyBoard]);
                        $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id' ");
                    }
                } else {
                    $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️خطا! تنها شماره های ایرانی تایید خواهند شد.\n/start", 'reply_markup' => $removeKeyBoard]);
                    $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id' ");
                }
            } else {
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "لطفا با استفاده از دکمه زیر اقدام به ثبت شماره خود نمایید 👇 ", 'reply_markup' => $pay_false]);
            }
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "لطفا با استفاده از دکمه زیر اقدام به ثبت شماره خود نمایید 👇 ", 'reply_markup' => $pay_false]);
        }
        break;


    case "phone++":
        $explode = explode('-', $user['otp']);
        if ($explode[3] >= 3) {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ تعداد دفعات مجاز وارد کردن کد به اتمام رسید، لطفا 10 دقیقه دیگر مجددا امتحان کنید\n/start", 'reply_markup' => $removeKeyBoard]);
            $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id' ");
        } else {
            if (is_numeric($text) && $text == $explode[1]) {
                $db->query("UPDATE user SET phone = '$explode[0]', otp = '', step = 'none' WHERE id = '$from_id' ");
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "🎉 تبریک حساب شما تایید شد.\n\n👇 از این پس قادر هستید از تمامی امکانات ربات، بدون محدودیت استفاده کنید.\n‌/start", 'reply_markup' => $removeKeyBoard]);
            } else {
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ کد وارد شده صحیح نمی باشد", 'reply_markup' => $back]);
                $attempt = $explode[3] + 1;
                $out = "$explode[0]-$explode[1]-$explode[2]-$attempt";
                $db->query("UPDATE user SET step = 'phone++', otp = '$out' WHERE id = '$from_id' ");
            }
        }

        break;

    //     case "verify":

    //         if (is_numeric($text) && strlen($text) == 16) {
    //             $msgid =  $MahdyarEn->SendMessage([
    //                 'chat_id' => $chat_id,
    //                 'text' => "🎥 لطفاً یک <b>ویدیو مسیج</b> ضبط کنید و به همین پیام ریپلای کنید:
    // 1️⃣ کارت بانکی خود را در دست بگیرید به‌گونه‌ای که <b>شماره کارت قابل مشاهده باشد</b> (در صورت تمایل می‌توانید سایر اطلاعات حساس را بپوشانید).
    // 2️⃣ سپس جمله زیر را بیان کنید:
    // «افزایش موجودی در ربات $botName مورد تأیید است.»",
    //                 'parse_mode' => 'HTML',
    //                 'disable_web_page_preview' => false,
    //                 'reply_markup' => $backInline
    //             ])['result']['message_id'];

    //             $db->query("UPDATE user SET step = 'verify2_{$text}_{$msgid}' WHERE id = '$from_id' ");
    //         } else {
    //             $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "🚫 #خطا 
    // کارت وارد شده معتبر نمی باشد شماره کارتتون رو بدون هیچ فاصله ای تایپ کنید 💳

    // شماره کارت باید 16 رقم باشد و اعداد بصورت لاتین وارد شوند مانند :

    // 5859831027734533", 'reply_markup' => $backInline]);
    //         }

    //         break;



    case "payOffline":
        if (!isset($data)) {
            if ($text >= 60000 and $text <= 3000000 and is_numeric($text)) {
                $price = intval($text);
                $factor_number = uniqid();

                $pay = $MahdyarEn->zarinPall('99539ee7-c5ed-434d-b883-60a4fb73b9a7', $price, "https://{$_SERVER['HTTP_HOST']}" . dirname($_SERVER['PHP_SELF']) . "/back.php", $factor_number);
                // $payment_url = "https://sandbox.zarinpal.com/pg/StartPay/" . $pay['data']['authority'];
                $payment_url = "https://www.zarinpal.com/pg/StartPay/" . $pay['data']['authority'];

                $btn = json_encode(['inline_keyboard' => [
                    [['text' => "💳 پرداخت", 'url' =>  $payment_url]],
                    [['text' => "بازگشت 🔙", 'callback_data' => 'back']],

                ]]);
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "💳 فاکتور خرید به مبلغ " . number_format($price) . " تومان \n\n📂 شماره فاکتور: <code>$factor_number</code>\n\nبا استفاده از دکمه زیر اقدام به پرداخت کنید", 'reply_markup' => $btn, 'parse_mode' => 'html']);
                $db->query("UPDATE user SET step = 'none'  WHERE id = '$from_id'");
                $expire = time();
                $db->query("INSERT into pay(`id`,`price`,`factor`,`time`,`type`,`authority`) VALUES('$from_id','$price','$factor_number','$expire','card','{$pay['data']['authority']}')");
            } else {
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⚠️ خطا! لطفا مبلغ را بصورت لاتین (123) و بین 60,000 الی 3,000,000 تومان وارد کنید.", 'reply_markup' => $backInline]);
            }
        }
        break;

    // send to all
    case "send+":
        if ($updateType != 'forward' and !isset($data)) {
            $alluser = $db->query("SELECT id from user")->num_rows;
            $timedone = $alluser < 100 ? 'یک دقیقه' : $MahdyarEn->getTime(round(($alluser / 100)) * 60);
            $msgIDtext = $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "〽️ پیام شما درحال ارسال به $alluser نفر می باشد.\n\n⏳ زمان تقریبی پایان عملیات: $timedone\n\n⏱ این پیام هر یک دقیقه آپدیت میشود.\n‌", 'reply_markup' => json_encode(['inline_keyboard' => [[['text' => "❌ لغو ارسال", 'callback_data' => "cancelSending"]],]])])['result']['message_id'];
            $db->query("UPDATE sendall SET step = 'send' ,`text` = '$message_id',chat = '$chat_id', MsgId = '$msgIDtext' , ChatID = '$from_id'");
        }
        break;

    // forward to all
    case "forward+":
        if (!isset($data)) {
            $db->query("UPDATE `user` SET `step` = 'none' WHERE `id` = '$from_id'");
            $alluser = $db->query("SELECT id from user")->num_rows;
            $timedone = $alluser < 100 ? 'یک دقیقه' : $MahdyarEn->getTime(round(($alluser / 100)) * 60);
            $msgIDtext = $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "〽️ پیام شما درحال فوروارد به $alluser نفر می باشد.\n\n⏳ زمان تقریبی پایان عملیات: $timedone\n\n⏱ این پیام هر یک دقیقه آپدیت میشود.\n‌", 'reply_markup' => json_encode(['inline_keyboard' => [[['text' => "❌ لغو ارسال", 'callback_data' => "cancelSending"]],]])])['result']['message_id'];
            $db->query("UPDATE sendall SET step = 'forward' ,`text` = '$message_id',chat = '$chat_id', MsgId = '$msgIDtext' , ChatID = '$from_id'");
        }
        break;


    // increase user stock
    case "increaseStock":
        $selecteduser = $db->query("SELECT * FROM user WHERE id = '$text'")->fetch_assoc();
        if ($selecteduser['id']) {
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "👈 خب حالا مقدار موجودی که میخواهید به کاربر اضافه شود را وارد کنید (به تومان)", 'parse_mode' => "MarkDown", 'reply_markup' => $backAdmin]);
            $db->query("UPDATE `user` SET `step` = 'increase_$text' WHERE `id` = '$from_id'");
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "💢 این کاربر در ربات عضو نمی باشد!", 'parse_mode' => "MarkDown", 'reply_markup' => $backAdmin]);
        }
        break;

    case "ban":
        $selecteduser = $db->query("SELECT * FROM user WHERE id = '$text'")->fetch_assoc();
        if ($selecteduser['id']) {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "کاربر مورد نظر بن شد", 'parse_mode' => "MarkDown", 'reply_markup' => $Admin]);
            $MahdyarEn->Sendmessage(['chat_id' => $text, 'text' => "شما از سمت پشتیبانی بن شدید", 'parse_mode' => "MarkDown",]);
            $db->query("UPDATE `user` SET `ban` = 1 WHERE `id` = '$text'");
            $db->query("UPDATE `user` SET `step` = 'none' WHERE `id` = '$from_id'");
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "💢 این کاربر در ربات عضو نمی باشد!", 'parse_mode' => "MarkDown", 'reply_markup' => $backAdmin]);
        }
        break;

    case "unban":
        $selecteduser = $db->query("SELECT * FROM user WHERE id = '$text'")->fetch_assoc();
        if ($selecteduser['id']) {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "کاربر مورد نظر آن بن شد", 'parse_mode' => "MarkDown", 'reply_markup' => $Admin]);
            $MahdyarEn->Sendmessage(['chat_id' => $text, 'text' => "شما از سمت پشتیبانی آن بن شدید", 'parse_mode' => "MarkDown",]);
            $db->query("UPDATE `user` SET `ban` = 0 WHERE `id` = '$text'");
            $db->query("UPDATE `user` SET `step` = 'none' WHERE `id` = '$from_id'");
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "💢 این کاربر در ربات عضو نمی باشد!", 'parse_mode' => "MarkDown", 'reply_markup' => $backAdmin]);
        }
        break;

    // decrease user stock
    case "decrease":
        $selecteduser = $db->query("SELECT * FROM user WHERE id = '$text'")->fetch_assoc();
        if ($selecteduser['id']) {
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "👈 خب حالا مقدار موجودی که میخواهید از کاربر کم شود را وارد کنید (به تومان)", 'parse_mode' => "MarkDown", 'reply_markup' => $backAdmin]);
            $db->query("UPDATE `user` SET `step` = 'decrease_$text' WHERE `id` = '$from_id'");
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "💢 این کاربر در ربات عضو نمی باشد!", 'parse_mode' => "MarkDown", 'reply_markup' => $backAdmin]);
        }
        break;


    // adding admin 
    case "addAdmin+":
        $selecteduser = $db->query("SELECT * FROM user WHERE id = '$text'")->fetch_assoc();
        if ($selecteduser["id"]) {
            $db->query("UPDATE `user` SET `step` = 'none' WHERE `id` = '$from_id'");
            $_ = $db->query("SELECT * FROM `settings` WHERE `type`= 'admin'")->fetch_assoc();
            $allAdmins = $_['type_id']  . $text . '|';
            $db->query("UPDATE `settings` SET `type_id` = '$allAdmins' WHERE `type`= 'admin'");
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "👈 کاربر [$text](tg://user?id=$text) ادمین ربات شد!", 'parse_mode' => "MarkDown", 'reply_markup' => $admin]);
            $MahdyarEn->Sendmessage(['chat_id' => $text, 'text' => "✅ شما به لیست ادمین های ربات اضافه شدید", 'parse_mode' => "MarkDown", 'reply_markup' => $admin]);
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "💢 این کاربر در ربات عضو نمی باشد!", 'parse_mode' => "MarkDown", 'reply_markup' => $backAdmin]);
        }
        break;

    // adding video 
    case "addVideo+":
        if (isset($video_id)) {
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "✅ ویدیو اضافه شد", 'parse_mode' => "MarkDown", 'reply_markup' => $admin]);
            $db->query("UPDATE `user` SET `step` = 'none' WHERE `id` = '$from_id'");
            $stmt = $db->prepare("INSERT INTO `settings`(`type`,`type_id`,`columnOne`) VALUES(?,?,?)");
            $type_ = "video";
            $stmt->bind_param("sss", $type_, $video_id, $caption);
            $stmt->execute();
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "💢 لطفا فقط ویدیو بفرستید", 'parse_mode' => "MarkDown", 'reply_markup' => $backAdmin]);
        }
        break;
    // remove video 
    case "removeVideo+":
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `id` = '$from_id'");

        if ($text == "بله") {
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "تمامی ویدیو ها حذف شدند!", 'parse_mode' => "MarkDown", 'reply_markup' => $admin]);
            $db->query("DELETE FROM settings WHERE `type` = 'video'");
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "عملیات لغو شد", 'parse_mode' => "MarkDown", 'reply_markup' => $admin]);
        }
        break;

    // remove ehgraz  
    case "ehraz+":
        $selecteduser = $db->query("SELECT * FROM user WHERE id = '$text'")->fetch_assoc();
        if ($selecteduser["id"]) {
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "👈 احراز [$text](tg://user?id=$text) حذف شد!", 'parse_mode' => "MarkDown", 'reply_markup' => $admin]);
            $db->multi_query("UPDATE `user` SET `step` = 'none' WHERE `id` = '$from_id';UPDATE `user` SET `verify` = '' WHERE `id`= '$text'");
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "💢 این کاربر در ربات عضو نمی باشد!", 'parse_mode' => "MarkDown", 'reply_markup' => $backAdmin]);
        }
        break;

    // remove specific admin
    case "removeAdmin+":
        if (isset($data)) {
            $allAdmins = str_replace($data . '|', '', $db->query("SELECT * FROM `settings` WHERE `type`= 'admin'")->fetch_assoc()['type_id']);
            $db->multi_query("UPDATE `user` SET `step` = 'none' WHERE `id` = '$from_id';UPDATE `settings` SET `type_id` = '$allAdmins' WHERE `type` = 'admin'");
            $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "👈 کاربر [$text](tg://user?id=$text) از لیست ادمین ها حذف شد!", 'parse_mode' => "MarkDown", 'reply_markup' => $admin]);
            $MahdyarEn->Sendmessage(['chat_id' => $text, 'text' => "❌ شما از لیست ادمین های ربات حذف شدید", 'parse_mode' => "MarkDown", 'reply_markup' => $home]);
        }
        break;

    case "sendDMtoUser":
        $selecteduser = $db->query("SELECT * FROM user WHERE id = '$text'")->fetch_assoc();
        if ($selecteduser['id']) {
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "👈 پیام خود را در قالب متن، عکس، ویدیو، گیف، استیکر و... ارسال کنید", 'parse_mode' => "MarkDown", 'reply_markup' => $backAdmin]);
            $db->query("UPDATE `user` SET `step` = 'sendDM_$text' WHERE `id` = '$from_id'");
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "💢 این کاربر در ربات عضو نمی باشد!", 'parse_mode' => "MarkDown", 'reply_markup' => $backAdmin]);
        }
        break;


    case "userInfo":
        @$selectUser = $db->query("SELECT * FROM user WHERE id = '$text'")->fetch_assoc();
        if ($selectUser["id"]) {

            @$getchat = $MahdyarEn->getChat(['chat_id' => $selectUser['id']])['result'];
            @$username = $getchat['username'] ? '@' . $getchat['username'] : 'ندارد';
            @$first_name = $getchat['first_name'] ?  $getchat['first_name'] : 'ندارد';
            @$last_name = $getchat['last_name'] ?  $getchat['last_name'] : 'ندارد';
            @$profile = $MahdyarEn->getUserProfilePhotos(['user_id' => $selectUser['id']])['result']['photos'][0][0]['file_id'];
            @$phoneStatus = $selectUser['phone'] ? 'تایید شده است' : 'تایید نشده است';
            @$verifyStatus = $selectUser['verify'] ? 'تایید شده است' : 'تایید نشده است';
            if ($profile != null) {
                $MahdyarEn->sendPhoto(['chat_id' => $chat_id, 'photo' => $profile, 'caption' => "اطلاعات <a href='tg://user?id={$selectUser['id']}'>کاربر</a> انتخاب شده به شرح زیر می باشد\n👤 نام کاربر: $first_name\n👨‍👨‍👦‍👦 نام خانوادگی: $last_name\n🔐 یوزرنیم کاربر: $username\nوضعیت تایید شماره: $phoneStatus\nوضعیت احراز هویت: $verifyStatus\n💳 موجودی کاربر: {$selectUser['stock']} تومان\n‌",  'reply_markup' => json_encode(['inline_keyboard' => [
                    [['text' => "دیدن لیست سفارش ها", 'callback_data' => "userOrders_$text"]],
                ]]), 'parse_mode' => 'html']);
            } else {
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "اطلاعات <a href='tg://user?id={$selectUser['id']}'>کاربر</a> انتخاب شده به شرح زیر می باشد\n👤 نام کاربر: $first_name\n👨‍👨‍👦‍👦 نام خانوادگی: $last_name\n🔐 یوزرنیم کاربر: $username\nوضعیت تایید شماره: $phoneStatus\nوضعیت احراز هویت: $verifyStatus\n💳 موجودی کاربر: {$selectUser['stock']} تومان\n‌", 'reply_markup' => $admin, 'reply_markup' => json_encode(['inline_keyboard' => [
                    [['text' => "دیدن لیست سفارش ها", 'callback_data' => "userOrders_$text"]],
                ]]), 'parse_mode' => 'html']);
            }
            if ($selectUser['phone']) {
                $MahdyarEn->sendContact(['chat_id' => $chat_id, 'phone_number' => $selectUser['phone'], 'first_name' => $first_name]);
            }
            if ($selectUser['verify']) {
                $explode = explode('-', $selectUser['verify']);
                $MahdyarEn->forwardMessage(['chat_id' => $chat_id, 'from_chat_id' => $text, 'message_id' => $explode[0]]);
                $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "شماره کارت\n<code>$explode[1]</code>", 'parse_mode' => "html", 'reply_markup' => $backAdmin]);
            }
            $db->query("UPDATE `user` SET `step` = 'none' WHERE `id` = '$from_id'");
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "💢 این کاربر در ربات عضو نمی باشد!", 'parse_mode' => "MarkDown", 'reply_markup' => $backAdmin]);
        }

        break;


    case "addDiscount":
        $text  = explode("\n", $text);
        if (count($text) < 3) {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ لطفا هر یک از 3 مورد خواسته شده را در یک خط جدا وارد کنید", 'reply_markup' => $backAdmin]);
        } elseif (!ctype_digit($text[1])) {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ خطا درصد تخفیف باید بصورت عددی لاتین و بزرگتر از صفر وارد شود مانند: 30", 'reply_markup' => $backAdmin]);
        } elseif (!ctype_digit($text[2])) {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ خطا! حداکثر استفاده باید بصورت عدد لاتین و بزرگتر تر از صفر باشد", 'parse_mode' => 'html', 'reply_markup' => $backAdmin]);
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "🎁 کد تخفیف <code>$text[0]</code> با $text[1] درصد تخفیف برای استفاده $text[2] نفر ایجاد شد.", 'parse_mode' => 'html', 'reply_markup' => $admin]);
            $db->multi_query("INSERT INTO settings(`type`,`type_id`,`columnOne`,`columnTwo`) VALUES('discount','{$text[0]}','{$text[1]}','{$text[2]}|0');UPDATE user SET step = 'none' WHERE id = '$from_id'");
        }
        break;
}



// strpos

if (strpos($data, 'prem*') !== false) {
    if (strpos($data, 'prem*') !== false) {
        $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
        $explode = explode('*', $data);

        if ($explode[1] == "3months") {
            $plan = __("prem1_confirm_plan", ['plan' => "پریمیوم 3 ماهه به مبلغ " . number_format($prem3)]);
            $price = $prem3;
        } elseif ($explode[1] == "6months") {
            $plan = __("prem1_confirm_plan", ['plan' => "پریمیوم 6 ماهه به مبلغ " . number_format($prem6)]);
            $price = $prem6;
        } elseif ($explode[1] == "12months") {
            $plan = __("prem1_confirm_plan", ['plan' => "پریمیوم 12 ماهه به مبلغ " . number_format($prem12)]);
            $price = $prem12;
        }

        $keyboard = json_encode(['inline_keyboard' => [
            [
                ['text' => __("prem1_button_discount"), 'callback_data' => "useDiscount*$explode[1]*$explode[2]"],
                ['text' => __("prem1_button_confirm"), 'callback_data' => "confirm*$explode[1]*$explode[2]"]
            ],
            [['text' => __("back"), 'callback_data' => 'back']]
        ]]);

        $MahdyarEn->Sendmessage([
            'chat_id' => $chat_id,
            'text' =>
            __("prem1_confirm_title") . "\n\n" .
                $plan . "\n\n" .
                __("prem1_confirm_username", ['username' => $explode[2]]) . "\n\n" .
                __("prem1_confirm_price", ['price' => number_format($price)]) . "\n\n" .
                __("prem1_confirm_footer"),
            'parse_mode' => 'html',
            'reply_markup' => $keyboard
        ]);
    }
} elseif (strpos($data, 'confirm*') !== false) {
    // حذف پیام قبلی برای تمیزی چت
    $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
    $explode = explode('*', $data);

    // ۱. تعیین پلن و قیمت
    $plan = ""; $price = 0; $prem_ = "";
    if (isset($explode[1])) {
        if ($explode[1] == "3months") { $plan = "پریمیوم 3 ماهه"; $price = $prem3; $prem_ = '3'; }
        elseif ($explode[1] == "6months") { $plan = "پریمیوم 6 ماهه"; $price = $prem6; $prem_ = '6'; }
        elseif ($explode[1] == "12months") { $plan = "پریمیوم 12 ماهه"; $price = $prem12; $prem_ = '12'; }
    }

    // ۲. اعمال کد تخفیف (در صورت وجود)
    if (isset($explode[3]) && !empty($explode[3])) {
        $selectCode = $db->query("SELECT * FROM settings WHERE `type` = 'discount' AND `type_id` = '{$explode[3]}'")->fetch_assoc();
        if ($selectCode) {
            $price = ((100 - $selectCode['columnOne']) / 100) * $price;
            // افزایش تعداد استفاده از کد تخفیف
            $_ = explode('|', $selectCode['columnTwo']); 
            $_[1] = (int)$_[1] + 1;
            $db->query("UPDATE settings SET columnTwo = '{$_[0]}|{$_[1]}' WHERE `type` = 'discount' AND `type_id` = '{$explode[3]}'");
        }
    }

    // ۳. بررسی موجودی کاربر
    if ($stock >= $price) {
        $factor_number = uniqid();
        
        // نمایش پیام "درحال پردازش"
        $procMsg = $MahdyarEn->Sendmessage([
            'chat_id' => $chat_id, 
            'text' => __('order_processing'), 
            'parse_mode' => 'html'
        ]);
        $procMsgId = $procMsg['result']['message_id'];

        // ۴. ارسال درخواست به API
        $targetUser = $explode[2];
        $result = $MahdyarEn->buyPremiumAPI($fragmentApiKey, $prem_, $targetUser);

        if ($result['ok']) {
            // --- الف: موفقیت ---
            
            // کسر موجودی
            $db->query("UPDATE user SET stock = stock - $price WHERE id = '$from_id'");

            // ثبت در دیتابیس
            $db->query("INSERT INTO orders(`id`,`name`,`price`,`username`,`buyer`,`date`,`stats`) VALUES('$factor_number','$plan','$price','$targetUser','$from_id','$date2 - $time','completed')");

            // ارسال لاگ به ادمین (تاپیک Premium)
            $logText = "🟣 <b>سفارش موفق: پرمیوم</b>\n────────────────\n";
            $logText .= "👤 <b>خریدار:</b> <a href='tg://user?id=$from_id'>" . htmlspecialchars($firstname) . "</a>\n";
            $logText .= "🛍 <b>پلن:</b> $plan\n";
            $logText .= "🎯 <b>برای:</b> @$targetUser\n";
            $logText .= "💰 <b>قیمت:</b> " . number_format($price) . " تومان\n";
            $logText .= "🔗 <a href='https://tonscan.org/tx/{$result['transaction_id']}'>مشاهده تراکنش</a>";
            sendLog('premium', $logText);

            // ویرایش پیام کاربر به فاکتور موفق
            $MahdyarEn->editMessageText([
                'chat_id' => $chat_id,
                'message_id' => $procMsgId,
                'text' => __("prem1_done_title") . "\n\n" . 
                          __("prem1_done_code", ['id' => $factor_number]) . "\n" . 
                          __("prem1_done_plan", ['plan' => $plan]) . "\n" . 
                          __("prem1_done_paid", ['price' => number_format($price)]),
                'parse_mode' => 'html',
                'reply_markup' => json_encode(['inline_keyboard' => [[['text' => __('start'), 'callback_data' => 'back']]]])
            ]);

            // گزارش عمومی (کانال پابلیک)
            if (isset($publicReport)) {
                $MahdyarEn->Sendmessage([
                    'chat_id' => $publicReport,
                    'text' => __('public_report', [
                        'buyer' => maskNumber($from_id),
                        'plan' => $plan,
                        'price' => number_format($price),
                        'date' => $date2, 'time' => $time,
                        'botusername' => $botusername,
                    ]),
                    'parse_mode' => 'html',
                    'reply_markup' => json_encode(['inline_keyboard' => [[['text' => __('virtual_services_bot'), 'url' => "https://t.me/$botusername"]]]])
                ]);
            }

        } else {
            // --- ب: خطا در انجام سفارش ---
            
            // پیام اطمینان‌بخش به کاربر
            $MahdyarEn->editMessageText([
                'chat_id' => $chat_id,
                'message_id' => $procMsgId,
                'text' => "❌ <b>سفارش انجام نشد</b>\n\nمتأسفانه سیستم در برقراری ارتباط با شبکه تلگرام دچار اختلال موقت شده است (شلوغی شبکه یا اتمام موجودی لحظه‌ای).\n\n💰 <b>هیچ مبلغی از حساب شما کسر نشد.</b>\n\nلطفاً چند دقیقه دیگر مجدداً تلاش کنید.",
                'parse_mode' => 'html',
                'reply_markup' => json_encode(['inline_keyboard' => [[['text' => __('back_to_menu'), 'callback_data' => 'home']]]])
            ]);

            // لاگ خطا برای ادمین
            sendLog('error', "⚠️ <b>خطا در خرید پرمیوم</b>\nکاربر: $from_id\nهدف: @$targetUser\nخطا: " . json_encode($result));
        }

    } else {
        // ۵. موجودی ناکافی
        $needed = number_format($price - $stock);
        $MahdyarEn->Sendmessage([
            'chat_id' => $chat_id,
            'text' => __("prem1_not_enough", ['price' => $needed]),
            'reply_markup' => $home,
            'parse_mode' => 'html'
        ]);
    }
    
    $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id' ");
    exit();
} elseif (strpos($data, 'verifFalse_') !== false) {
    $explode = explode('_', $data);
    $MahdyarEn->Sendmessage(['chat_id' => $explode[1], 'text' => "❌ مدرک احرازهویت شما توسط ادمین ربات رد شد.\nبرای اطلاعات بیشتر با پشتیبانی ربات در ارتباط باشید", 'parse_mode' => 'html']);
    $MahdyarEn->EditMessageReplyMarkup(['chat_id' => $chat_id, 'message_id' => $message_id, 'reply_markup' => json_encode(['inline_keyboard' => [[['text' => "مدرک احراز هویت رد شد", 'callback_data' => "n"]],]])]);
} elseif (strpos($data, 'verifTrue_') !== false) {
    $explode = explode('_', $data);
    $MahdyarEn->Sendmessage(['chat_id' => $explode[1], 'text' => "✅ مدرک احرازهویت شما با موفقیت تایید شد.\nاز این به بعد میتوانید بصورت ریالی هم پرداخت کنید.", 'parse_mode' => 'html']);
    $MahdyarEn->EditMessageReplyMarkup(['chat_id' => $chat_id, 'message_id' => $message_id, 'reply_markup' => json_encode(['inline_keyboard' => [[['text' => "مدرک تایید شد", 'callback_data' => "n"]],]])]);
    $db->query("UPDATE user SET verify = '$explode[2]-$explode[3]' WHERE id = '$explode[1]' ");
} elseif (strpos($data, 'sendFish_') !== false) {
    $explode = explode('_', $data);
    $backInline =  json_encode(['inline_keyboard' => [
        [['text' => "انصراف", 'callback_data' => 'back']],
    ]]);
    $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => "💳 لطفا رسید واریزی را ارسال کنید و منتظر تایید ادمین بمانید!", 'reply_markup' => $backInline]);
    $db->query("UPDATE user SET step = 'sendFish_{$explode[1]}_$explode[2]'  WHERE id = '$from_id'");
} elseif (strpos($step, 'sendFish_') !== false) {
    $explode = explode('_', $step);
    $selectFactor = $db->query("SELECT * FROM pay WHERE factor = '$explode[2]'")->fetch_assoc();
    if ($updateType == "photo") {
        $msgID = $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "فیش شما ارسال شد. منتظر تایید باشید ✅", 'reply_markup' => $explode[3] ? null : $home])['result']['message_id'];
        $_ = $explode[3] ? "payTrue_$explode[1]_$explode[2]_{$msgID}_$from_id" : "payTrue_$explode[1]_$explode[2]";
        $key = json_encode(['inline_keyboard' => [
            [['text' => "تایید پرداخت", 'callback_data' => "$_"]],
            [['text' => "⭕️ مشکل در پرداخت", 'callback_data' => "payFalse_$explode[1]_$message_id"]],
        ]]);
        $ex = explode('-', $user['verify']);
        $MahdyarEn->sendPhoto(['chat_id' => $reportChannel, 'photo' => $photo_id, 'caption' => $caption . "\n\n#پرداخت_جدید\n👤 کاربر: <a href='tg://user?id=$explode[1]'>$explode[1]</a>\n📂 شماره فاکتور: $explode[2]\n💳 مبلغ: " . number_format($selectFactor['price']) . " تومان\nشماره کارت بانکی ثبت شده از کاربر: $ex[1]", 'reply_markup' => $key, 'parse_mode' => 'html']);
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `id` = '$from_id'");
    } else {
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "لطفا فیش خود را در قالب عکس ارسال کنید", 'reply_markup' => $back]);
    }
} elseif (strpos($data, 'payTrue_') !== false) {
    $explode = explode('_', $data);
    $selectFactor = $db->query("SELECT * FROM pay WHERE factor = '$explode[2]'")->fetch_assoc();
    $MahdyarEn->Sendmessage(['chat_id' => $explode[1], 'text' => "✅ پرداخت شما با شماره {$explode[2]} با موفقیت تایید شد و موجودی شما به مقدار " . number_format($selectFactor['price']) . " تومان افزایش یافت."]);
    $usera = $db->query("SELECT * FROM user WHERE id = '$explode[1]'")->fetch_assoc();

    $MahdyarEn->Sendmessage(['chat_id' => $reportChannel, 'text' => "✅ پرداخت با شماره {$explode[2]} با موفقیت تایید شد و موجودی کاربر <a href='tg://user?id=$explode[1]'>$explode[1]</a> به مقدار " . number_format($selectFactor['price']) . " تومان افزایش یافت.", 'parse_mode' => 'html']);
    $db->multi_query("UPDATE user SET stock = stock+{$selectFactor['price']} WHERE id = '$explode[1]';UPDATE pay SET stats = 1 WHERE `factor` = '$explode[2]';");
    $MahdyarEn->EditMessageReplyMarkup(['chat_id' => $chat_id, 'message_id' => $message_id, 'reply_markup' => json_encode(['inline_keyboard' => [[['text' => "پرداخت تایید شد", 'callback_data' => "n"]],]])]);
} elseif (strpos($step, 'setnum_') !== false) {
    $explode = explode('_', $step);
    if (preg_match('/([0-9]{5,})/', $text)) {
        if ($text == $explode[2]) {
            $db->query("UPDATE user SET phone = '$explode[1]', step = 'none' WHERE id = '$from_id' ");
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "🎉 تبریک حساب شما تایید شد.\n\n👇 از این پس قادر هستید از تمامی امکانات ربات، بدون محدودیت استفاده کنید.\n‌", 'reply_markup' => $deletekey]);
            $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
            $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id - 1]);
            sleep(0);
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "به منوی اصلی بازگشتید.", 'reply_markup' => $home]);
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "کد ارسالی معتبر نمیباشد", 'reply_markup' => $back]);
            $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
        }
    } else {
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "کد رو برسی کرده و مجدد ارسال کنید‌", 'reply_markup' => $back, 'parse_mode' => 'html']);
    }
} elseif (strpos($data, 'payFalse_') !== false) {
    $explode = explode('_', $data);
    $msgId = $MahdyarEn->Sendmessage(['chat_id' =>  $explode[1], 'text' => "❌ فیش ارسالی شما توسط ادمین رد شد.\nجهت کسب اطلاعات بیشتر با پشتیبانی در ارتباط باشید.", 'parse_mode' => 'html']);
    $MahdyarEn->EditMessageReplyMarkup(['chat_id' => $chat_id, 'message_id' => $message_id, 'reply_markup' => json_encode(['inline_keyboard' => [[['text' => "پرداخت لغو شد", 'callback_data' => "n"]],]])]);
} elseif (strpos($data, 'lang_') !== false) {

    $explode = explode('_', $data);
    $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
    if ($explode[1] == "fa") {

        $MahdyarEn->Sendmessage(['chat_id' =>  $from_id, 'text' => "🌐 زبان ربات با موفقیت به فارسی تغییر یافت.\n/start", 'parse_mode' => 'html']);
    } elseif ($explode[1] == "ru") {
        $MahdyarEn->Sendmessage(['chat_id' =>  $from_id, 'text' => "🌐 Язык бота успешно изменён на русский.\n/start", 'parse_mode' => 'html']);
    } else {
        $MahdyarEn->Sendmessage(['chat_id' =>  $from_id, 'text' => "🌐 Bot language successfully changed to English.\n/start", 'parse_mode' => 'html']);
    }

    $db->multi_query("UPDATE `user` SET `step` = 'none' WHERE `id` = '$from_id';UPDATE `user` SET `lang` = '{$explode[1]}' WHERE `id` = '$from_id';");
}
// payCurrency select
elseif (strpos($data, 'payCurrency_') !== false) {
    $explode = explode('_', $data);
    $MahdyarEn->editMessageText([
        'chat_id' => $chat_id,
        'message_id' => $message_id,
        'text' => __('payOffline_enter_amount'),
        'reply_markup' => $backInline
    ]);
    $db->query("UPDATE user SET step = 'payCurrency_$explode[1]' WHERE id = '$from_id'");
}

// payCurrency input
elseif (strpos($step, 'payCurrency_') !== false) {
    $explode = explode('_', $step);
    if ($text >= 100000 && $text <= 30000000 && is_numeric($text)) {
        $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id'");
        $MahdyarEn->Sendmessage([
            'chat_id' => $chat_id,
            'text' => __('payCurrency_calculating')
        ]);

        if ($explode[1] == "ton") {
            $data = getBitpinDataByCode("TON_IRT");
            $c_price = $text / $data['price'];
            $data2 = getBitpinDataByCode("TON_USDT");
            $u_price =    $data2['price'] * $c_price;
            $u_price = roundUp($u_price);
            $symbol = "TONCOIN";
        } elseif ($explode[1] == "trx") {
            $data = getBitpinDataByCode("TRX_IRT");
            $c_price = $text / $data['price'];
            $data2 = getBitpinDataByCode("TRX_USDT");
            $u_price =  $data2['price'] * $c_price;
            $u_price = roundUp($u_price);

            $symbol = "TRX";
        }

        $amount = intval($text);
        $factor_number = uniqid();
        $xRocket = $MahdyarEn->xRocketPayApi($XRocketAPI, roundUp($c_price), $factor_number, $symbol);

        if ($xRocket['success']) {
            $network = strtoupper($explode[1]);
            $cryptoAmount = roundUp($c_price);
            
            $logText = "🪙 <b>افزایش موجودی: کریپتو (Crypto)</b>\n";
            $logText .= "────────────────\n";
            $logText .= "👤 <b>کاربر:</b> <a href='tg://user?id=$from_id'>" . htmlspecialchars($firstname) . "</a>\n";
            $logText .= "🔗 <b>شبکه:</b> $network\n";
            $logText .= "💎 <b>مقدار واریزی:</b> $cryptoAmount\n";
            $logText .= "💵 <b>معادل تومانی:</b> " . number_format($amount) . " تومان\n";
            $logText .= "🧾 <b>شماره فاکتور:</b> <code>$factor_number</code>\n";
            $logText .= "📅 <b>زمان:</b> $date2 | $time";
            
            sendLog('deposit', $logText);
            $expire = time() + 60 * 10;
            $db->query("INSERT INTO pay(id,price,factor,`time`,`type`,usd,currency) VALUES('$from_id','$amount','$factor_number','$expire','xRocket','$u_price','$c_price')");
        } else {
            $MahdyarEn->Sendmessage([
                'chat_id' => $chat_id,
                'text' => __('payCurrency_error', ['amount' => $c_price]),
                'reply_markup' => $home
            ]);
        }
    } else {
        $MahdyarEn->Sendmessage([
            'chat_id' => $chat_id,
            'text' => __('invalid_amount'),
            'reply_markup' => $backInline
        ]);
    }
}

// star order
elseif (strpos($step, 'star*') !== false) {
    $explode = explode('*', $step);
    if (preg_match('/@?([a-zA-Z0-9_]{5,})/', $text)) {
        $text = str_replace("@", "", $text);
        $username = checkUsername($text);
        $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id'");
        $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);

        if ($username) {
            $price = $explode[1] * $starsPrice;
            $keyboard = json_encode([
                'inline_keyboard' => [
                    [[
                        'text' => __('star2_button', [
                            'stars' => $explode[1],
                            'price' => number_format($price)
                        ]),
                        'callback_data' => "star2*$explode[1]*$text"
                    ]],
                    [['text' => __('back'), 'callback_data' => 'back']]
                ]
            ]);
            $MahdyarEn->SendMessage([
                'chat_id' => $chat_id,
                'text' => __('star2_confirm', ['username' => $username]),
                'reply_markup' => $keyboard,
                'parse_mode' => 'html',
                'disable_web_page_preview' => true,

            ]);
        } else {
            $MahdyarEn->Sendmessage([
                'chat_id' => $chat_id,
                'text' => __('prem1_invalid_username'),
                'reply_markup' => $backInline,
                'parse_mode' => 'html'
            ]);
        }
    } else {
        $MahdyarEn->Sendmessage([
            'chat_id' => $chat_id,
            'text' => __('prem1_invalid_username'),
            'reply_markup' => $backInline,
            'parse_mode' => 'html'
        ]);
    }
} elseif (strpos($data, 'star2*') !== false) {
    $explode = explode('*', $data);
    $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
    $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id' ");

    $price = $explode[1] * $starsPrice;
    $plan = "{$explode[1]} " . __('star_plan_name');

    $keyboard = json_encode(['inline_keyboard' => [
        [
            ['text' => __('button_discount'), 'callback_data' => "useDiscount2*{$explode[1]}*{$explode[2]}"],
            ['text' => __('button_confirm'), 'callback_data' => "starConfirm*{$explode[1]}*{$explode[2]}"],
        ],
        [
            ['text' => __('back'), 'callback_data' => 'back']
        ]
    ]]);

    $MahdyarEn->Sendmessage([
        'chat_id' => $chat_id,
        'text' => __('order_info', [
            'plan' => $plan,
            'username' => $explode[2],
            'price' => number_format($price),
        ]),
        'parse_mode' => 'html',
        'reply_markup' => $keyboard,
    ]);
} elseif (strpos($data, 'starConfirm*') !== false) {
    $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
    $explode = explode('*', $data);
    
    $amountStars = $explode[1];
    $targetUser = $explode[2];
    $price = $amountStars * $starsPrice;
    $plan = "$amountStars " . __('star_plan_name');

    // اعمال تخفیف
    if (isset($explode[3]) && !empty($explode[3])) {
        $selectCode = $db->query("SELECT * from settings WHERE `type` = 'discount' AND `type_id` = '{$explode[3]}'")->fetch_assoc();
        if($selectCode) {
            $price = ((100 - $selectCode['columnOne']) / 100) * $price;
            $_ = explode('|', $selectCode['columnTwo']);
            $_[1] = (int)$_[1] + 1;
            $db->query("UPDATE settings SET columnTwo = '{$_[0]}|{$_[1]}' WHERE `type` = 'discount' AND `type_id` = '{$explode[3]}'");
        }
    }

    if ($stock >= $price) {
        $factor_number = uniqid();
        
        $procMsg = $MahdyarEn->Sendmessage([
            'chat_id' => $chat_id,
            'text' => __('order_processing'),
            'parse_mode' => 'html'
        ]);
        $procMsgId = $procMsg['result']['message_id'];
        
        $result = $MahdyarEn->buyStarsAPI($fragmentApiKey, $amountStars, $targetUser);
        
        if ($result['ok']) {
            $db->query("UPDATE user SET stock = stock - $price WHERE id = '$from_id'");
            $db->query("INSERT INTO orders(`id`,`name`,`price`,`username`,`buyer`,`date`,`stats`) VALUES('$factor_number','$plan','$price','$targetUser','$from_id','$date2 - $time','completed')");

            // لاگ موفقیت
            $logText = "⭐️ <b>سفارش موفق: استارز</b>\n────────────────\n";
            $logText .= "👤 <b>خریدار:</b> <a href='tg://user?id=$from_id'>" . htmlspecialchars($firstname) . "</a>\n";
            $logText .= "✨ <b>تعداد:</b> $amountStars\n";
            $logText .= "🎯 <b>برای:</b> @$targetUser\n";
            $logText .= "💰 <b>قیمت:</b> " . number_format($price) . " تومان\n";
            $logText .= "🔗 <a href='[https://tonscan.org/tx/](https://tonscan.org/tx/){$result['transaction_id']}'>مشاهده تراکنش</a>";
            sendLog('stars', $logText);

            // پیام موفقیت به کاربر
            $MahdyarEn->editMessageText([
                'chat_id' => $chat_id,
                'message_id' => $procMsgId,
                'text' => __("order_done", [
                    'factor_number' => $factor_number,
                    'plan' => $plan,
                    'username' => $targetUser,
                    'price' => number_format($price)
                ]),
                'parse_mode' => 'html',
                'reply_markup' => json_encode(['inline_keyboard' => [[['text' => __('start'), 'callback_data' => 'back']]]])
            ]);

            // گزارش عمومی
            if (isset($publicReport)) {
                $MahdyarEn->Sendmessage([
                    'chat_id' => $publicReport,
                    'text' => __('public_report', [
                        'buyer' => maskNumber($from_id),
                        'plan' => $plan,
                        'price' => number_format($price),
                        'date' => $date2, 'time' => $time,
                        'botusername' => $botusername,
                    ]),
                    'parse_mode' => 'html',
                    'reply_markup' => json_encode(['inline_keyboard' => [[['text' => __('virtual_services_bot'), 'url' => "[https://t.me/$botusername](https://t.me/$botusername)"]]]])
                ]);
            }

        } else {
            // خطا
            $MahdyarEn->editMessageText([
                'chat_id' => $chat_id,
                'message_id' => $procMsgId,
                'text' => "❌ <b>خطا در واریز استارز</b>\n\nمتأسفانه سیستم در حال حاضر قادر به پردازش این سفارش نیست (موجودی ولت ربات یا شلوغی شبکه).\n\n💰 <b>هیچ مبلغی از حساب شما کسر نشد.</b>\n\nلطفاً اندکی صبر کرده و دوباره تلاش کنید.",
                'parse_mode' => 'html',
                'reply_markup' => json_encode(['inline_keyboard' => [[['text' => __('back_to_menu'), 'callback_data' => 'home']]]])
            ]);
            
            sendLog('error', "⚠️ <b>خطا در خرید استارز</b>\nکاربر: $from_id\nمقدار: $amountStars\nخطا: " . json_encode($result));
        }
    } else {
        $needed = number_format($price - $stock);
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => __('not_enough_balance', ['amount' => $needed]), 'reply_markup' => $home, 'parse_mode' => 'html']);
    }
    $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id' ");
    exit();
}


// ton order

elseif (strpos($data, 'tonConfirm*') !== false) {
    $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
    $explode = explode('*', $data);
    
    $amountTon = $explode[1];
    $targetUser = $explode[2];
    $price = $amountTon * $tonPrice;
    $plan = "$amountTon TON";

    if (isset($explode[3]) && !empty($explode[3])) {
        $selectCode = $db->query("SELECT * from settings WHERE `type` = 'discount' AND `type_id` = '{$explode[3]}'")->fetch_assoc();
        if($selectCode) {
            $price = ((100 - $selectCode['columnOne']) / 100) * $price;
            $_ = explode('|', $selectCode['columnTwo']);
            $_[1] = (int)$_[1] + 1;
            $db->query("UPDATE settings SET columnTwo = '{$_[0]}|{$_[1]}' WHERE `type` = 'discount' AND `type_id` = '{$explode[3]}'");
        }
    }

    if ($stock >= $price) {
        $factor_number = uniqid();
        
        $procMsg = $MahdyarEn->Sendmessage([
            'chat_id' => $chat_id,
            'text' => __('order_processing'),
            'parse_mode' => 'html'
        ]);
        $procMsgId = $procMsg['result']['message_id'];
        
        $result = $MahdyarEn->buyTonAPI($fragmentApiKey, $amountTon, $targetUser);
        
        if ($result['ok']) {
            $db->query("UPDATE user SET stock = stock - $price WHERE id = '$from_id'");
            $db->query("INSERT INTO orders(`id`,`name`,`price`,`username`,`buyer`,`date`,`stats`) VALUES('$factor_number','$plan','$price','$targetUser','$from_id','$date2 - $time','completed')");

            // لاگ موفقیت
            $logText = "💎 <b>سفارش موفق: تون کوین</b>\n────────────────\n";
            $logText .= "👤 <b>خریدار:</b> <a href='tg://user?id=$from_id'>" . htmlspecialchars($firstname) . "</a>\n";
            $logText .= "⚖️ <b>مقدار:</b> $amountTon TON\n";
            $logText .= "🎯 <b>برای:</b> @$targetUser\n";
            $logText .= "💰 <b>قیمت:</b> " . number_format($price) . " تومان\n";
            $logText .= "🔗 <a href='https://tonscan.org/tx/{$result['transaction_id']}'>مشاهده تراکنش</a>";
            sendLog('ton', $logText);

            $MahdyarEn->editMessageText([
                'chat_id' => $chat_id,
                'message_id' => $procMsgId,
                'text' => __("order_done", [
                    'factor_number' => $factor_number,
                    'plan' => $plan,
                    'username' => $targetUser,
                    'price' => number_format($price)
                ]),
                'parse_mode' => 'html',
                'reply_markup' => json_encode(['inline_keyboard' => [[['text' => __('start'), 'callback_data' => 'back']]]])
            ]);

            // گزارش عمومی
            if (isset($publicReport)) {
                $MahdyarEn->Sendmessage([
                    'chat_id' => $publicReport,
                    'text' => __('public_report', [
                        'buyer' => maskNumber($from_id),
                        'plan' => $plan,
                        'price' => number_format($price),
                        'date' => $date2, 'time' => $time,
                        'botusername' => $botusername,
                    ]),
                    'parse_mode' => 'html',
                    'reply_markup' => json_encode(['inline_keyboard' => [[['text' => __('virtual_services_bot'), 'url' => "https://t.me/$botusername"]]]])
                ]);
            }

        } else {
            // خطا
            $MahdyarEn->editMessageText([
                'chat_id' => $chat_id,
                'message_id' => $procMsgId,
                'text' => "❌ <b>تراکنش ناموفق</b>\n\nانتقال TON به دلیل مشکل در شبکه بلاکچین یا کیف پول مبدأ انجام نشد.\n\n💰 <b>موجودی شما دست‌نخورده باقی ماند.</b>\n\nلطفاً دقایقی دیگر مجدداً درخواست دهید.",
                'parse_mode' => 'html',
                'reply_markup' => json_encode(['inline_keyboard' => [[['text' => __('back_to_menu'), 'callback_data' => 'home']]]])
            ]);
            
            sendLog('error', "⚠️ <b>خطا در انتقال TON</b>\nکاربر: $from_id\nمقدار: $amountTon\nخطا: " . json_encode($result));
        }
    } else {
        $needed = number_format($price - $stock);
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => __('not_enough_balance', ['amount' => $needed]), 'reply_markup' => $home, 'parse_mode' => 'html']);
    }
    $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id' ");
    exit();
} elseif (strpos($data, 'ton2*') !== false) {
    $explode = explode('*', $data);
    $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
    $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id' ");

    $price = $explode[1] * $tonPrice;
    $plan = "{$explode[1]} " . __('ton_plan_name');

    $keyboard = json_encode(['inline_keyboard' => [
        [
            // ['text' => __('button_discount'), 'callback_data' => "useDiscount2*{$explode[1]}*{$explode[2]}"],
            ['text' => __('button_confirm'), 'callback_data' => "tonConfirm*{$explode[1]}*{$explode[2]}"],
        ],
        [
            ['text' => __('back'), 'callback_data' => 'back']
        ]
    ]]);

    $MahdyarEn->Sendmessage([
        'chat_id' => $chat_id,
        'text' => __('order_info', [
            'plan' => $plan,
            'username' => $explode[2],
            'price' => number_format($price),
        ]),
        'parse_mode' => 'html',
        'reply_markup' => $keyboard,
    ]);
} elseif (strpos($data, 'tonConfirm*') !== false) {
    $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);

    $explode = explode('*', $data);
    $price = $explode[1] * $tonPrice;
    $plan = "{$explode[1]} " . __('ton_plan_name');

    if ($explode[3]) {
        $selectCode  = $db->query("SELECT * from settings WHERE `type` = 'discount' AND `type_id` = '{$explode[3]}'")->fetch_assoc();
        $price = ((100 - $selectCode['columnOne']) / 100) * $price;
        $_ =  explode('|', $selectCode['columnTwo']);
        $_[1] += 1;
        $db->query("UPDATE settings SET columnTwo = '{$_[0]}|{$_[1]}' WHERE `type` = 'discount' AND `type_id` = '{$explode[3]}'");
    }

    if ($stock >= $price) {
        $factor_number = uniqid();
        $x = $MahdyarEn->Sendmessage([
            'chat_id' => $chat_id,
            'text' => __('order_processing'),
            'parse_mode' => 'html'
        ])['result']['message_id'];
        $result = $MahdyarEn->buyTonAPI($fragmentApiKey, $explode[1], $explode[2]);
        if ($result['ok']) {

            $db->multi_query("UPDATE user SET stock = stock-$price WHERE id = '$from_id'");
// دریافت اطلاعات
$targetUser = $explode[2]; // یوزرنیم مقصد

$logText = "⭐️ <b>سفارش جدید: استارز (Stars)</b>\n";
$logText .= "────────────────\n";
$logText .= "👤 <b>خریدار:</b> <a href='tg://user?id=$from_id'>" . htmlspecialchars($firstname) . "</a>\n";
$logText .= "✨ <b>مقدار بسته:</b> {$explode[1]} استارز\n";
$logText .= "🎯 <b>برای اکانت:</b> @$targetUser\n";
$logText .= "💰 <b>مبلغ پرداختی:</b> " . number_format($price) . " تومان\n";
$logText .= "🏷 <b>کد پیگیری:</b> <code>$factor_number</code>\n";
$logText .= "📅 <b>زمان:</b> $date2 | $time\n";
$logText .= "🔗 <a href='https://tonscan.org/tx/{$result['transaction_id']}'>مشاهده تراکنش در بلاکچین</a>";

sendLog('stars', $logText);
            $MahdyarEn->EditMessageReplyMarkup(['chat_id' => $chat_id, 'message_id' => $x, 'reply_markup' => json_encode(['inline_keyboard' => [
                [
                    ['text' => __('start'), 'callback_data' => 'back']
                ]
            ]])]);
            $btn = json_encode(['inline_keyboard' => [
                // [['text' => __('virtual_services_bot'), 'url' => "https://t.me/$botusername"], ['text' => 'تراکنش 💎', 'url' => "https://tonscan.org/tx/{$result['transaction_id']}"]],
                [['text' => __('virtual_services_bot'), 'url' => "https://t.me/$botusername"]],
            ]]);
            $MahdyarEn->Sendmessage([
                'chat_id' => $reportChannel,
                'text' => __('admin_new_order', [
                    'from_id' => $from_id,
                    'factor_number' => $factor_number,
                    'plan' => $plan,
                    'username' => $explode[2],
                    'price' => number_format($price),
                    'link' => "https://tonscan.org/tx/{$result['transaction_id']}",

                ]),
                'parse_mode' => 'html',
                // 'reply_markup' => $btn,

            ]);

            $MahdyarEn->Sendmessage([
                'chat_id' => $publicReport,
                'text' => __('public_report', [
                    'buyer' => maskNumber($from_id),
                    'plan' => $plan,
                    'price' => number_format($price),
                    'date' => $date2,
                    'time' => $time,
                    'botusername' => $botusername,
                ]),
                'parse_mode' => 'html',
                'reply_markup' => $btn,
            ]);
            $db->query("INSERT into orders(`id`,`name`,`price`,`username`,`buyer`,`date`,`stats`) VALUES('$factor_number','$plan','$price','{$explode[2]}','$from_id','$date2 - $time','completed')");
        } else {
            $MahdyarEn->Sendmessage([
                'chat_id' => $chat_id,
                'text' => __('error_try_again_later'),
                'parse_mode' => 'html',
                'reply_markup' => $home,
            ]);
            $MahdyarEn->Sendmessage([
                'chat_id' => $reportChannel,
                'text' => __('error_try_again_later_admin', [
                    'from_id' => $from_id,
                    'factor_number' => $factor_number,
                    'plan' => $plan,
                    'username' => $explode[2],
                    'price' => number_format($price),
                    'errorMsg' => $result['message'],
                    'error' => json_encode($result['message']),
                ]),
                'parse_mode' => 'html',
                'reply_markup' => $keyboard,
            ]);
        }
    } else {
        $needed = number_format($price - $stock);
        $MahdyarEn->Sendmessage([
            'chat_id' => $chat_id,
            'text' => __('not_enough_balance', ['amount' => $needed]),
            'reply_markup' => $home,
            'parse_mode' => 'html',
        ]);
        $factor_number = uniqid();
        $price = intval($price);

        $pay = $MahdyarEn->zarinPall('99539ee7-c5ed-434d-b883-60a4fb73b9a7', $price, "https://{$_SERVER['HTTP_HOST']}" . dirname($_SERVER['PHP_SELF']) . "/back.php", $factor_number);
        // $payment_url = "https://sandbox.zarinpal.com/pg/StartPay/" . $pay['data']['authority'];
        $payment_url = "https://www.zarinpal.com/pg/StartPay/" . $pay['data']['authority'];

        $btn = json_encode(['inline_keyboard' => [
            [['text' => "💳 پرداخت", 'url' =>  $payment_url]],
            [['text' => "بازگشت 🔙", 'callback_data' => 'back']],

        ]]);
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "💳 فاکتور خرید به مبلغ " . number_format($price) . " تومان \n\n📂 شماره فاکتور: <code>$factor_number</code>\n\nبا استفاده از دکمه زیر اقدام به پرداخت کنید", 'reply_markup' => $btn, 'parse_mode' => 'html']);
        $db->query("UPDATE user SET step = 'none'  WHERE id = '$from_id'");
        $expire = time();
        $db->query("INSERT into pay(`id`,`price`,`factor`,`time`,`type`,`authority`) VALUES('$from_id','$price','$factor_number','$expire','card','{$pay['data']['authority']}')");
    }
    $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id' ");
    exit();
}



// elseif (strpos($data, 'buyGift_') !== false) {
//     $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);

//     $explode = explode('_', $data);
//     // @$gift = $db->query("SELECT * FROM `gifts` where id = '$explode[1]'")->fetch_assoc();
//     $gift = findItemById($gifts_list, $explode[1]);

//     $keyboard = json_encode(['inline_keyboard' => [
//         [
//             ['text' => __('gift_confirm'), 'callback_data' => "buyGift2*{$explode[1]}"],
//         ],
//         [
//             ['text' => __('back'), 'callback_data' => 'back2']
//         ]
//     ]]);
//     $xx =   $MahdyarEn->sendSticker(['chat_id' => $chat_id, "sticker" => new CURLFile("gift_bot/sticker/$explode[1].tgs")]);
//     $MahdyarEn->sendMessage([
//         'chat_id' => $chat_id,
//         'text' => __('gift_info', ['id' => $explode[1], "stars" => $gift["price"], "price" => number_format($gift["price"] * $starsPrice), "emoji" => $gift['sticker']["emoji"]]),
//         'reply_markup' => $keyboard,
//         'parse_mode' => 'html',
//     ]);
// } 
elseif (strpos($data, 'buyGift2*') !== false) {
    $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id - 1]);
    $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
    $_ = $MahdyarEn->sendMessage(['chat_id' => $chat_id, 'text' => "⌛️", 'parse_mode' => 'html'])['result']['message_id'];
    $explode = explode('*', $data);
    $gift = findItemById($gifts_list, $explode[1]);
    $msg_id =   $MahdyarEn->sendSticker(['chat_id' => $chat_id, "sticker" => new CURLFile("gift_bot/sticker/$explode[1].tgs")])['result']['message_id'];
    $MahdyarEn->sendMessage([
        'chat_id' => $chat_id,
        'text' => __('gift_count'),
        'parse_mode' => 'html',
        'reply_markup' => $backInline2,
        'reply_to_message_id' => $msg_id
    ]);
    $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $_]);

    $db->query("UPDATE user SET step = 'buyGift*$explode[1]' WHERE `id` = '$from_id'");
} elseif (strpos($step, 'buyGift*') !== false) {
    $explode = explode('*', $step);
    // @$gift = $db->query("SELECT * FROM `gifts` where id = '$explode[1]'")->fetch_assoc();
    if (is_numeric($text)) {
        $db->query("UPDATE user SET step = 'buyGift2*$explode[1]*$text' WHERE `id` = '$from_id'");
        $MahdyarEn->sendMessage([
            'chat_id' => $chat_id,
            'text' => __('send_gift_username'),
            'reply_markup' => $backInline,
            'parse_mode' => 'html',
        ]);
    } else {
        $MahdyarEn->sendMessage([
            'chat_id' => $chat_id,
            'text' => __('gift_count'),
            'reply_markup' => $backInline,
            'parse_mode' => 'html',
        ]);
    }
} elseif (strpos($step, 'buyGift2*') !== false) {
    $explode = explode('*', $step);
    // @$gift = $db->query("SELECT * FROM `gifts` where id = '$explode[1]'")->fetch_assoc();
    $gift = findItemById($gifts_list, $explode[1]);

    if (preg_match('/@?([a-zA-Z0-9_]{5,})/', $text)) {
        $text = str_replace("@", "", $text);
        $username = checkUsername($text);
        $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id' ");
        $price = $gift["price"] * $starsPrice * $explode[2];

        $keyboard = json_encode(['inline_keyboard' => [
            [['text' => __("gift_btn", ["price" => number_format($price)]), 'callback_data' => "gitftConfrim*$explode[1]*$explode[2]*$text"], ['text' => __("gift_btn2"), 'callback_data' => 'back']],
        ]]);
        $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);

        if ($username) {
            $MahdyarEn->SendMessage([
                'chat_id' => $chat_id,
                'text' => __("gift_confirm2", ['username' => $username, "gift" => $gift['sticker']["emoji"], "count" => $explode[2], "price" => number_format($price)]),
                'reply_markup' => $keyboard,
                'disable_web_page_preview' => true,
                'parse_mode' => 'html'
            ]);
        } else {
            $MahdyarEn->SendMessage([
                'chat_id' => $chat_id,
                'text' => __("prem1_invalid_username"),
                'reply_markup' => $backInline,
                'parse_mode' => 'html'
            ]);
        }
    } else {
        $MahdyarEn->SendMessage([
            'chat_id' => $chat_id,
            'text' => __("prem1_invalid_username"),
            'reply_markup' => $backInline,
            'parse_mode' => 'html'
        ]);
    }
} elseif (strpos($data, 'gitftConfrim*') !== false) {
    $explode = explode('*', $data);
    // @$gift = $db->query("SELECT * FROM `gifts` where id = '$explode[1]'")->fetch_assoc();
    $gift = findItemById($gifts_list, $explode[1]);
    $price = $gift["price"] * $starsPrice * $explode[2];
    $plan = "$explode[2] گیفت {$gift['sticker']["emoji"]}";
    if ($stock >= $price) {
        $factor_number = uniqid();

        // ATUOMATE ============================  GIFT //

        function websocket_send($host, $port, $path, $data)
        {
            $key = base64_encode(random_bytes(16));
            $header = "GET $path HTTP/1.1\r\n"
                . "Host: $host:$port\r\n"
                . "Upgrade: websocket\r\n"
                . "Connection: Upgrade\r\n"
                . "Sec-WebSocket-Key: $key\r\n"
                . "Sec-WebSocket-Version: 13\r\n\r\n";

            $sock = fsockopen($host, $port, $errno, $errstr, 2);
            if (!$sock) {
                return "Connection failed: $errstr ($errno)";
            }

            fwrite($sock, $header);
            fread($sock, 1500);

            $frame = encode_ws_frame($data);
            fwrite($sock, $frame);

            $response = decode_ws_frame(fread($sock, 2000));
            fclose($sock);
            return $response;
        }

        function encode_ws_frame($data)
        {
            $bytes = [];
            $bytes[0] = 129; // FIN + opcode
            $length = strlen($data);
            if ($length <= 125) {
                $bytes[1] = 128 | $length; // MASK + length
            } else {
                $bytes[1] = 128 | 126;
                $bytes[] = ($length >> 8) & 255;
                $bytes[] = $length & 255;
            }

            $mask = [rand(0, 255), rand(0, 255), rand(0, 255), rand(0, 255)];
            $bytes = array_merge($bytes, $mask);

            for ($i = 0; $i < $length; $i++) {
                $bytes[] = ord($data[$i]) ^ $mask[$i % 4];
            }

            return implode(array_map("chr", $bytes));
        }

        function decode_ws_frame($data)
        {
            $payload_len = ord($data[1]) & 127;
            if ($payload_len === 126) {
                $offset = 4;
            } elseif ($payload_len === 127) {
                $offset = 10;
            } else {
                $offset = 2;
            }
            return substr($data, $offset);
        }

        $data = json_encode([
            "action" => "send_gift",
            "chat_id" => $explode[3],
            "gift_id" => $gift["id"],
            "count" => $explode[2],
        ]);

        $response = websocket_send("localhost", $giftPort, "/", $data);
        $response = json_decode($response, true);
        file_put_contents('sdfsdfsdfsdfsd12.txt', json_encode($response));
        // ATUOMATE ============================  GIFT //
        if ($response["status"] == "ok") {
            $db->multi_query("UPDATE user SET stock = stock-$price WHERE id = '$from_id'");
            $MahdyarEn->EditMessageReplyMarkup(['chat_id' => $chat_id, 'message_id' => $message_id, 'reply_markup' => json_encode(['inline_keyboard' => [[['text' => __("done_btn_gift"), 'callback_data' => 'none']]]])]);
            $MahdyarEn->Sendmessage([
                'chat_id' => $chat_id,
                'text' => __('gift_order_complete', [
                    'factor_number' => $factor_number,
                    'gift' => $gift['sticker']["emoji"],
                    'count' =>  $explode[2],
                    'username' => $explode[3],
                    'price' => number_format($price),
                ]),
                'parse_mode' => 'html'
            ]);
            $MahdyarEn->Sendmessage([
                'chat_id' => $chat_id,
                'text' => __('return_main_menu'),
                'parse_mode' => 'html',
                'reply_markup' => $home,
            ]);
            $MahdyarEn->Sendmessage([
                'chat_id' => $reportChannel,
                'text' => __('admin_new_order', [
                    'from_id' => $from_id,
                    'factor_number' => $factor_number,
                    'plan' => $plan,
                    'username' => $explode[3],
                    'price' => number_format($price),
                    'link' => "موجود نمی باشد",

                ]),
                'parse_mode' => 'html',
            ]);
            $btn = json_encode(['inline_keyboard' => [
                [['text' => __('virtual_services_bot'), 'url' => "https://t.me/$botusername"]],
            ]]);
            $MahdyarEn->Sendmessage([
                'chat_id' => $publicReport,
                'text' => __('public_report', [
                    'buyer' => maskNumber($from_id),
                    'plan' => $plan,
                    'price' => number_format($price),
                    'date' => $date2,
                    'time' => $time,
                    'botusername' => $botusername,
                ]),
                'parse_mode' => 'html',
                'reply_markup' => $btn,
            ]);
            $db->query("INSERT into orders(`id`,`name`,`price`,`username`,`buyer`,`date`,`stats`) VALUES('$factor_number','$plan','$price','{$explode[3]}','$from_id','$date2 - $time','completed')");
        } else {
            $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id' ");
            $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);

            $MahdyarEn->Sendmessage([
                'chat_id' => $chat_id,
                'text' => __('gift_error'),
                'parse_mode' => 'html',
                'reply_markup' => $home,

            ]);
        }
    } else {
        $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);

        $needed = number_format($price - $stock);
        $MahdyarEn->Sendmessage([
            'chat_id' => $chat_id,
            'text' => __('not_enough_balance', ['amount' => $needed]),
            'reply_markup' => $home,
            'parse_mode' => 'html',
        ]);
    }
    $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id' ");
} elseif (strpos($data, 'notif_') !== false) {
    $explode = explode('_', $data);
    $MahdyarEn->EditMessageReplyMarkup([
        'chat_id' => $chat_id,
        'message_id' => $message_id,
        'reply_markup' => json_encode(['inline_keyboard' => [[['text' => __('order_completed'), 'callback_data' => "n"]]]])
    ]);
    $order = $db->query("SELECT * FROM orders WHERE id = '{$explode[1]}'")->fetch_assoc();
    $MahdyarEn->Sendmessage([
        'chat_id' => $order['buyer'],
        'text' => __('order_success_message', [
            'plan' => $order['name'],
            'username' => $order['username'],
            'factor_number' => $explode[1],
        ]),
        'parse_mode' => 'html',
    ]);
    $btn = json_encode(['inline_keyboard' => [
        [['text' => __('virtual_services_bot'), 'url' => "https://t.me/$botusername"]],
    ]]);
    $MahdyarEn->Sendmessage([
        'chat_id' => $publicReport,
        'text' => __('public_report', [
            'buyer' => maskNumber($order['buyer']),
            'plan' => $order['name'],
            'price' => number_format($order['price']),
            'date' => $date2,
            'time' => $time,
            'botusername' => $botusername,
        ]),
        'parse_mode' => 'html',
        'reply_markup' => $btn,
    ]);
    $db->query("UPDATE orders SET stats = 'completed' WHERE id = '{$explode[1]}' ");
}


// PANEL


// increase user stock
else if (strpos($step, 'increase_') !== false) {
    $explode = explode('_', $step);
    $_ = $db->query("SELECT * FROM user WHERE `id` = '$explode[1]'")->fetch_assoc();
    if (is_numeric($text)) {
        $newStock =  $_['stock'] + $text;
        $MahdyarEn->Sendmessage(['chat_id' => $explode[1], 'text' => "✅ موجودی شما به مقدار $text تومان افزایش یافت"]);
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "✅ موجودی کاربر افزایش یافت، موجودی جدید کاربر: $newStock", 'reply_markup' => $admin]);
        $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id'");
        $db->query("UPDATE user SET stock = stock + $text WHERE id = '$explode[1]'");
    } else {
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "❌ مقدار عددی وارد کنید", 'reply_markup' => $backAdmin]);
    }
}
// decrease user stock
else if (strpos($step, 'decrease_') !== false) {
    $explode = explode('_', $step);
    $_ = $db->query("SELECT * FROM user WHERE `id` = '$explode[1]'")->fetch_assoc();

    if (is_numeric($text)) {
        $newStock =  $_['stock'] - $text;
        $MahdyarEn->Sendmessage(['chat_id' => $explode[1], 'text' => "⭕️ موجودی شما به مقدار $text کاهش یافت"]);
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "✅ موجودی کاربر کاهش یافت، موجودی جدید کاربر: $newStock", 'reply_markup' => $admin]);
        $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id'");
        $db->query("UPDATE user SET stock = stock - $text WHERE id = '$explode[1]'");
    } else {
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "❌ مقدار عددی وارد کنید", 'reply_markup' => $backAdmin]);
    }
} else if (strpos($step, 'sendDM_') !== false) {
    $explode = explode('_', $step);
    switch ($updateType) {
        case "message":
            $MahdyarEn->sendMessage(['chat_id' => $explode[1], 'text' => "$text",  'parse_mode' => 'MarkDown']);
            break;

        case "photo":
            $MahdyarEn->sendPhoto(['chat_id' => $explode[1], 'photo' => $photo_id, 'caption' =>  $caption,  'parse_mode' => 'MarkDown']);
            break;

        case "video":
            $MahdyarEn->sendVideo(['chat_id' => $explode[1], 'video' => $video_id, 'caption' =>  $caption,  'parse_mode' => 'MarkDown']);
            break;

        case "sticker":
            $MahdyarEn->sendSticker(['chat_id' => $explode[1], 'sticker' => $sticker_id,  'parse_mode' => 'MarkDown']);
            break;

        case "voice":
            $MahdyarEn->sendVoice(['chat_id' => $explode[1], 'voice' => $voice_id, 'caption' =>  $caption,  'parse_mode' => 'MarkDown']);
            break;

        case "document":
            $MahdyarEn->sendDocument(['chat_id' => $explode[1], 'document' => $file_id, 'caption' =>  $caption,  'parse_mode' => 'MarkDown']);
            break;

        case "audio":
            $MahdyarEn->sendAudio(['chat_id' => $explode[1], 'audio' => $audio_id, 'caption' =>  $caption,  'parse_mode' => 'MarkDown']);
            break;

        case "animation":
            $MahdyarEn->sendAnimation(['chat_id' => $explode[1], 'animation' => $gif_id, 'caption' =>  $caption,  'parse_mode' => 'MarkDown']);
            break;
    }
    $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "✋ پیام شما برای کاربر ( <a href='tg://user?id=$explode[1]'>$explode[1]</a> ) ارسال شد.\nدرصورت نیاز پیام بعدی خود را ارسال کنید",  'parse_mode' => 'html', 'reply_markup' => $back]);
} // see all user Orders
elseif (strpos($data, 'userOrders_') !== false) {
    $explode = explode('_', $data);
    $order = $db->query("SELECT * FROM orders WHERE buyer = '$explode[1]'");

    $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⌛️"]);
    if ($order->num_rows == 0) {
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "⭕️ کاربر انتخاب شده سفارشی ندارد", 'reply_markup' => $admin]);
    } else {

        while ($row = $order->fetch_assoc()) {
            $expireDate = strtotime($row['expire']) - strtotime(date('Y/m/d H:i', time()));
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "🏷 کد پیگیری : <code>{$row['id']}</code>\n🛒 پلن انتخابی : {$row['name']}\n➿ برای یوزرنیم : @{$row['username']}\n\n💰 مبلغ " . number_format($row['price']), 'parse_mode' => 'html', 'reply_markup' => $home]);
        }
    }
} // change plan information
elseif (strpos($data, 'edit_') !== false) {
    $explode = explode('_', $data);
    $db->query("UPDATE user SET step = 'edit|$explode[1]|$explode[2]' WHERE `id` = '$from_id'");
    $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "شما درحال ویرایش $explode[1] می باشید. لطفا مقدار جدید را وارد کنید", 'parse_mode' => "MarkDown", 'reply_markup' => $back]);
} else if (strpos($step, 'edit|') !== false) {
    $explode = explode('|', $step);
    if (is_numeric($text)) {
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "✅ با موفقیت تغییر یافت.", 'parse_mode' => 'html', 'reply_markup' => $admin]);
        $db->query("UPDATE `settings` SET `columnTwo` = '$text' WHERE type_id = '$explode[1]'");
        $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id'");
    } else {
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "بصورت عددی وارد کنید", 'parse_mode' => 'html', 'reply_markup' => $back]);
    }
} elseif (strpos($data, 'stats_') !== false) {
    $explode = explode('_', $data);
    $setting = $db->query("SELECT * FROM settings WHERE `type` = '$explode[1]'")->fetch_assoc();
    $stats = '';
    switch ($setting['type_id']) {
        case 'on':
            $stats = 'off';
            break;
        case 'off':
            $stats = 'on';
            break;
    }
    $callback_keyboard = $MahdyarEn->Callback_Message()['reply_markup']['inline_keyboard'];
    $newRows = [];
    $newCols = [];
    foreach ($callback_keyboard as $row) {
        $newCols = [];
        foreach ($row as $col) {
            if ($col['callback_data'] == "stats_$explode[1]") {
                $newCols[] =   ['text' => $stats == 'on' ? '✅' : '❌', 'callback_data' =>  $col['callback_data']];
            } else {
                if ($col['text'] == "on" || $col['text'] == "off") {
                    $newCols[] =   ['text' => $col['text'] == 'on' ? '✅' : '❌', 'callback_data' =>  $col['callback_data']];
                } else {
                    $newCols[] =   ['text' => $col['text'], 'callback_data' =>  $col['callback_data']];
                }
            }
        }
        $newRows[] = $newCols;
    }
    $db->query("UPDATE settings SET `type_id` = '$stats' WHERE `type` = '$explode[1]'");
    $MahdyarEn->EditMessageReplyMarkup(['chat_id' => $from_id, 'message_id' => $message_id, 'reply_markup' => json_encode(['inline_keyboard' => $newRows])]);
} elseif (strpos($data, 'removeCh_') !== false) {
    $explode = explode('_', $data);
    $db->query("UPDATE `user` SET `step` = 'none' WHERE `id` = '$from_id'");
    $db->query("DELETE FROM settings WHERE `type` = 'channel' AND `type_id` = '$explode[1]'");
    $MahdyarEn->deletemessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
    $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "👌 کانال مورد نظر از لیست جوین اجباری حذف شد", 'parse_mode' => "html", 'reply_markup' => $admin]);
} // remove discount
elseif (strpos($data, 'removeDis~') !== false) {
    $explode = explode('~', $data);
    $MahdyarEn->editMessageText(['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => "‼️ آیا از حذف کد تخفیف اطمینان دارید؟ این عملیات غیرقابل بازگشت می باشد\n‌", 'parse_mode' => "MarkDown", 'reply_markup' => json_encode(['resize_keyboard' => true, 'inline_keyboard' => [[['text' => "بله", 'callback_data' => "confrimDis~$explode[1]"], ['text' =>  "خیر", 'callback_data' => "noimnot"]]]])]);
}
// confirm remove
// confirm remove
elseif (strpos($data, 'confrimDis~') !== false) {
    $explode = explode('~', $data);
    $db->multi_query("DELETE FROM settings WHERE `type` = 'discount'  AND `type_id` = '$explode[1]';UPDATE user SET step = 'none' WHERE id = '$from_id'");
    $MahdyarEn->deleteSendMessage(
        ['chat_id' => $from_id, 'message_id' => $message_id],
        ['chat_id' => $from_id, 'text' => __('admin_discount_deleted'), 'parse_mode' => "MarkDown", 'reply_markup' => $admin]
    );
} elseif (strpos($data, 'useDiscount*') !== false) {
    $explode = explode('*', $data);
    $MahdyarEn->deleteSendMessage(
        ['chat_id' => $from_id, 'message_id' => $message_id],
        ['chat_id' => $from_id, 'text' => __('send_discount_code'), 'reply_markup' => $backInline]
    );
    $db->query("UPDATE user SET step = 'useDiscount*{$explode[1]}*{$explode[2]}' WHERE id = '$from_id'");
} else if (strpos($step, 'useDiscount*') !== false) {
    $explode = explode('*', $step);
    $selectCode = $db->query("SELECT * from settings WHERE `type` = 'discount' AND `type_id` = '$text'")->fetch_assoc();
    if ($selectCode['type']) {
        $_ = explode('|', $selectCode['columnTwo']);
        if ($_[0] > $_[1]) {
            if ($explode[1] == "3months") {
                $plan = __("plan_3month", ['price' => number_format($prem3)]);
                $price = $prem3;
            } else if ($explode[1] == "6months") {
                $plan = __("plan_6month", ['price' => number_format($prem6)]);
                $price = $prem6;
            } else if ($explode[1] == "12months") {
                $plan = __("plan_12month", ['price' => number_format($prem12)]);
                $price = $prem12;
            }
            $newPrice = ((100 - $selectCode['columnOne']) / 100) * $price;

            $keyboard = json_encode(['inline_keyboard' => [
                [['text' => __("confirm_order_btn"), 'callback_data' => "confirm*$explode[1]*$explode[2]*{$selectCode['type_id']}"]],
                [['text' => __("back_btn"), 'callback_data' => 'back']],
            ]]);

            $MahdyarEn->Sendmessage([
                'chat_id' => $chat_id,
                'text' => __("discount_applied_msg", [
                    'percent' => $selectCode['columnOne'],
                    'plan' => $plan,
                    'username' => $explode[2],
                    'price' => number_format($price),
                    'newPrice' => number_format($newPrice)
                ]),
                'parse_mode' => 'html',
                'reply_markup' => $keyboard
            ]);

            $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id'");
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => __('discount_limit_reached'), 'parse_mode' => "MarkDown", 'reply_markup' => $home]);
        }
    } else {
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => __('discount_invalid_code'), 'reply_markup' => $backInline, 'parse_mode' => 'html']);
    }
} else if (strpos($step, 'useDiscount*') !== false) {
    $explode = explode('*', $step);
    $selectCode = $db->query("SELECT * from settings WHERE `type` = 'discount' AND `type_id` = '$text'")->fetch_assoc();
    if ($selectCode['type']) {
        $_ = explode('|', $selectCode['columnTwo']);
        if ($_[0] > $_[1]) {
            if ($explode[1] == "3months") {
                $plan = __("plan_3month", ['price' => number_format($prem3)]);
                $price = $prem3;
            } else if ($explode[1] == "6months") {
                $plan = __("plan_6month", ['price' => number_format($prem6)]);
                $price = $prem6;
            } else if ($explode[1] == "12months") {
                $plan = __("plan_12month", ['price' => number_format($prem12)]);
                $price = $prem12;
            }
            $newPrice = ((100 - $selectCode['columnOne']) / 100) * $price;

            $keyboard = json_encode(['inline_keyboard' => [
                [['text' => __("confirm_order_btn"), 'callback_data' => "confirm*$explode[1]*$explode[2]*{$selectCode['type_id']}"]],
                [['text' => __("back_btn"), 'callback_data' => 'back']],
            ]]);

            $MahdyarEn->Sendmessage([
                'chat_id' => $chat_id,
                'text' => __("discount_applied_msg", [
                    'percent' => $selectCode['columnOne'],
                    'plan' => $plan,
                    'username' => $explode[2],
                    'price' => number_format($price),
                    'newPrice' => number_format($newPrice)
                ]),
                'parse_mode' => 'html',
                'reply_markup' => $keyboard
            ]);

            $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id'");
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => __('discount_limit_reached'), 'parse_mode' => "MarkDown", 'reply_markup' => $home]);
        }
    } else {
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => __('discount_invalid_code'), 'reply_markup' => $backInline, 'parse_mode' => 'html']);
    }
} elseif (strpos($data, 'useDiscount2*') !== false) {
    $explode = explode('*', $data);
    $MahdyarEn->deleteSendMessage([
        'chat_id' => $from_id,
        'message_id' => $message_id
    ], [
        'chat_id' => $from_id,
        'text' => __('enter_discount_code'),
        'reply_markup' => $backInline
    ]);
    $db->query("UPDATE user SET step = 'useDiscount2*{$explode[1]}*{$explode[2]}' WHERE id = '$from_id'");
} else if (strpos($step, 'useDiscount2*') !== false) {
    $explode = explode('*', $step);
    $selectCode = $db->query("SELECT * from settings WHERE `type` = 'discount' AND `type_id` = '$text'")->fetch_assoc();

    if ($selectCode['type']) {
        $_ = explode('|', $selectCode['columnTwo']);
        if ($_[0] > $_[1]) {
            $price = $explode[1] * $star;
            $plan = "{$explode[1]} " . __('telegram_stars');
            $newPrice = ((100 - $selectCode['columnOne']) / 100) * $price;
            $keyboard = json_encode(['inline_keyboard' => [
                [['text' => __('confirm_order'), 'callback_data' => "starConfirm*$explode[1]*$explode[2]"]],
                [['text' => "🔜 " . __('back'), 'callback_data' => 'back']],
            ]]);

            $MahdyarEn->Sendmessage([
                'chat_id' => $chat_id,
                'text' => __('discount_valid_star', [
                    'percent' => $selectCode['columnOne'],
                    'plan' => $plan,
                    'username' => $explode[2],
                    'old_price' => number_format($price),
                    'new_price' => number_format($newPrice)
                ]),
                'parse_mode' => 'html',
                'reply_markup' => $keyboard
            ]);
            $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id'");
        } else {
            $MahdyarEn->Sendmessage([
                'chat_id' => $chat_id,
                'text' => __('discount_limit_reached'),
                'parse_mode' => "MarkDown",
                'reply_markup' => $home
            ]);
        }
    } else {
        $MahdyarEn->Sendmessage([
            'chat_id' => $chat_id,
            'text' => __('discount_invalid'),
            'reply_markup' => $backInline,
            'parse_mode' => 'html'
        ]);
    }
} else if (strpos($step, 'verify2_') !== false) {
    $explode = explode('_', $step);
    $video_note = $MahdyarEn->video_note();
    if (isset($video_note)) {
        $video_noteID = $MahdyarEn->video_noteid();
        $reply = $MahdyarEn->ReplyToMessagetxt();
        if (isset($reply)) {
            $reply_msgid = $MahdyarEn->ReplyToMessageID();

            if ($reply_msgid == $explode[2]) {
                $db->query("UPDATE user SET step = 'none' WHERE id = '$from_id' ");
                $keyboard = json_encode(['inline_keyboard' => [
                    [['text' => "رد", 'callback_data' => "verifFalse_$from_id"], ['text' => "تایید", 'callback_data' => "verifTrue_{$from_id}_{$message_id}_$explode[1]"]],
                ]]);
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "👩🏻‍💻 درخواست احراز هویت شما ثبت شده و در دست بررسی تیم $botName میباشد نتیجه به شما اعلام میگردد."]);
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "به منوی اصلی بازگشتید.", 'reply_markup' => $home]);
                $msg_id =  $MahdyarEn->sendVideoNote(['chat_id' => $reportChannel, 'video_note' => $video_noteID, 'parse_mode' => 'html'])['result']['message_id'];
                $MahdyarEn->Sendmessage(['chat_id' => $reportChannel, 'photo' => $photo_id, 'text' => "#احراز هویت\n\nکاربر <a href='tg://user?id=$from_id'>$from_id</a>\nشماره کارت: $explode[1]", 'reply_markup' => $keyboard, 'parse_mode' => 'html', 'reply_to_message_id' => $msg_id]);
            } else {
                $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "خطا ویدیو مسیج را تنها به پیام مشخص شده ریپلای کنید!", 'reply_markup' => $backInline]);
            }
        } else {
            $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "خطا! ویدیو مسیج به پیامی ریپلای نشده است", 'reply_markup' => $backInline]);
        }
    } else {
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "فقط ویدیومسیج بفرستید", 'reply_markup' => $backInline]);
    }
}

// change plan information
elseif (strpos($data, 'editSetting*') !== false) {
    $explode = explode('*', $data);
    @$setting_ = $db->query("SELECT `columnTwo`,`type`,`type_id` FROM `settings` WHERE `type` = '{$explode[1]}'")->fetch_assoc();
    $db->query("UPDATE `user` SET step = 'editSetting|$explode[1]' WHERE `id` = '$from_id'");
    // $MahdyarEn->deleteMessage(['chat_id' => $chat_id, 'message_id' => $message_id]);
    $MahdyarEn->Sendmessage(['chat_id' => $from_id, 'text' => "شما درحال ویرایش {$setting_['columnTwo']} می باشید. لطفا مقدار جدید را وارد کنید", 'parse_mode' => "MarkDown", 'reply_markup' => $back]);
} else if (strpos($step, 'editSetting|') !== false) {
    if (!isset($data)) {
        $explode = explode('|', $step);
        $MahdyarEn->Sendmessage(['chat_id' => $chat_id, 'text' => "✅ با موفقیت تغییر یافت.", 'parse_mode' => 'html', 'reply_markup' => $admin]);
        $db->multi_query("UPDATE `settings` SET `type_id` = '$text' WHERE `type` = '$explode[1]';UPDATE `user` SET step = 'none' WHERE id = '$from_id'");
    }
}
