<?php
/**
 * Cron Job - نسخه نهایی و اصلاح شده برای هاست
 */

// نمایش ارورها برای عیب‌یابی
ini_set('display_errors', 1);
error_reporting(E_ALL);

date_default_timezone_set("Asia/Tehran");

// ✅ استفاده از مسیر مطلق (__DIR__) برای جلوگیری از خطای "File not found"
$dir = __DIR__; 

if (file_exists($dir . '/config.php')) require_once $dir . '/config.php';
else die("❌ Error: config.php not found in $dir");

if (file_exists($dir . '/class/Base.php')) require_once $dir . '/class/Base.php';
else die("❌ Error: class/Base.php not found");

require_once $dir . '/jdf.php';

$MahdyarEn = new Base($token);
$now = time();

echo "⏰ Time: " . jdate("H:i:s") . "<br>";

// کوئری: دریافت سفارش‌های منتظر پرداخت که زمانشان گذشته
$sql = "SELECT pay.id AS chat_id, pay.message_id, pay.factor, orders.stats, pay.time 
        FROM pay 
        JOIN orders ON pay.factor = orders.id 
        WHERE pay.type = 'product_buy' 
        AND orders.stats = 'waiting_pay' 
        AND pay.time < $now";

$result = $db->query($sql);

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $factor_id = $row['factor'];
        $chat_id = $row['chat_id'];
        $msg_id = $row['message_id'];

        echo "Processing Order: $factor_id (MsgID: $msg_id)... ";

        // اگر آیدی پیام خالی باشد، کاری نمی‌توان کرد
        if (empty($msg_id)) {
            echo "❌ Skipped (No Message ID)<br>";
            continue;
        }
        
        // 1. منقضی کردن در دیتابیس
        $db->query("UPDATE orders SET stats = 'expired' WHERE id = '$factor_id'");
        
        // 2. متن جدید پیام
        $expired_text = "⏳ <b>زمان پرداخت به پایان رسید!</b>\n\n";
        $expired_text .= "⚠️ این لینک پرداخت به دلیل گذشت زمان (۵ دقیقه) منقضی شده است.\n";
        $expired_text .= "🧾 شماره سفارش: <code>$factor_id</code>\n\n";
        $expired_text .= "❌ لطفاً برای خرید، مجدداً اقدام کنید.";
        
        $keyboard = json_encode(['inline_keyboard' => [
            [['text' => "🏠 بازگشت به منوی اصلی", 'callback_data' => 'back']]
        ]]);

        // 3. ارسال درخواست ادیت
        $res = $MahdyarEn->editMessageText([
            'chat_id' => $chat_id,
            'message_id' => $msg_id,
            'text' => $expired_text,
            'parse_mode' => 'html',
            'reply_markup' => $keyboard
        ]);

        if ($res['ok']) echo "✅ Edited Successfully.<br>";
        else echo "⚠️ Telegram Error: " . $res['description'] . "<br>";
    }
} else {
    echo "✅ No expired orders found.";
}
?>